/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.services.systemmanagement;

import com.anaptecs.jeaf.core.api.MessageConstants;
import com.anaptecs.jeaf.core.api.Service;
import com.anaptecs.jeaf.core.servicechannel.api.Command;
import com.anaptecs.jeaf.core.spi.CheckResult;
import com.anaptecs.jeaf.services.systemmanagement.ServiceProviderInfo;
import com.anaptecs.jeaf.services.systemmanagement.SystemManagementService;
import com.anaptecs.jeaf.xfun.api.XFun;
import com.anaptecs.jeaf.xfun.api.errorhandling.ErrorCode;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import com.anaptecs.jeaf.xfun.api.trace.Trace;
import java.io.Serializable;
import java.lang.reflect.Method;

final class CheckServiceProvider_ServiceProviderInfo_SystemManagementService_Command
extends Command {
    private static final long serialVersionUID = 1L;
    private static final int MILLISECONDS = 1000000;
    private static final Method SERVICE_METHOD;
    private final Object[] parameters;
    private final ServiceProviderInfo serviceProviderInfo;

    CheckServiceProvider_ServiceProviderInfo_SystemManagementService_Command(ServiceProviderInfo pServiceProviderInfo) {
        super(SystemManagementService.class);
        this.serviceProviderInfo = pServiceProviderInfo;
        this.parameters = new Object[]{this.serviceProviderInfo};
    }

    public Serializable execute(Service pTargetService) {
        SystemManagementService lService = (SystemManagementService)pTargetService;
        Trace lTrace = XFun.getTrace();
        lTrace.write(MessageConstants.EXECUTING_SERVICE_CALL, new String[]{this.getCalledServiceMethod()});
        long lStartTime = System.nanoTime();
        CheckResult lResult = lService.checkServiceProvider(this.serviceProviderInfo);
        String lDuration = Long.toString((System.nanoTime() - lStartTime) / 1000000L);
        lTrace.write(MessageConstants.RETURNING_FROM_SERVICE_CALL, new String[]{this.getCalledServiceMethod(), lDuration});
        return lResult;
    }

    public final Method getServiceMethod() {
        return SERVICE_METHOD;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    static {
        try {
            SERVICE_METHOD = SystemManagementService.class.getMethod("checkServiceProvider", ServiceProviderInfo.class);
        }
        catch (NoSuchMethodException e) {
            ErrorCode lErrorCode = MessageConstants.SERVICE_METHOD_DOES_NOT_EXIST;
            String[] lParams = new String[]{SystemManagementService.class.getName(), "checkServiceProvider(ServiceProviderInfo.class)"};
            throw new JEAFSystemException(lErrorCode, lParams, (Throwable)e);
        }
    }
}

