/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.services.systemmanagement;

import com.anaptecs.jeaf.core.api.MessageConstants;
import com.anaptecs.jeaf.core.api.Service;
import com.anaptecs.jeaf.core.servicechannel.api.Command;
import com.anaptecs.jeaf.services.systemmanagement.ApplicationLocalization;
import com.anaptecs.jeaf.services.systemmanagement.LocalizationAdminService;
import com.anaptecs.jeaf.services.systemmanagement.LocalizationApplicationException;
import com.anaptecs.jeaf.services.systemmanagement.LocalizationValidity;
import com.anaptecs.jeaf.xfun.api.XFun;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import com.anaptecs.jeaf.xfun.api.trace.Trace;
import com.anaptecs.jeaf.xfun.types.Period;
import java.io.Serializable;
import java.lang.reflect.Method;

final class CreateLocalizationValidity_ApplicationLocalization_Period_String_LocalizationAdminService_Command
extends Command {
    private static final long serialVersionUID = 1L;
    private static final int MILLISECONDS = 1000000;
    private static final Method SERVICE_METHOD;
    private final Object[] parameters;
    private final ApplicationLocalization applicationLocalization;
    private final Period validity;
    private final String description;

    CreateLocalizationValidity_ApplicationLocalization_Period_String_LocalizationAdminService_Command(ApplicationLocalization pApplicationLocalization, Period pValidity, String pDescription) {
        super(LocalizationAdminService.class);
        this.applicationLocalization = pApplicationLocalization;
        this.validity = pValidity;
        this.description = pDescription;
        this.parameters = new Object[]{this.applicationLocalization, this.validity, this.description};
    }

    public Serializable execute(Service pTargetService) throws LocalizationApplicationException {
        LocalizationAdminService lService = (LocalizationAdminService)pTargetService;
        Trace lTrace = XFun.getTrace();
        lTrace.write(MessageConstants.EXECUTING_SERVICE_CALL, new String[]{this.getCalledServiceMethod()});
        long lStartTime = System.nanoTime();
        LocalizationValidity lResult = lService.createLocalizationValidity(this.applicationLocalization, this.validity, this.description);
        String lDuration = Long.toString((System.nanoTime() - lStartTime) / 1000000L);
        lTrace.write(MessageConstants.RETURNING_FROM_SERVICE_CALL, new String[]{this.getCalledServiceMethod(), lDuration});
        return lResult;
    }

    public final Method getServiceMethod() {
        return SERVICE_METHOD;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    static {
        try {
            SERVICE_METHOD = LocalizationAdminService.class.getMethod("createLocalizationValidity", ApplicationLocalization.class, Period.class, String.class);
        }
        catch (NoSuchMethodException e) {
            throw new JEAFSystemException(MessageConstants.SERVICE_METHOD_DOES_NOT_EXIST, (Throwable)e, new String[]{LocalizationAdminService.class.getName(), "createLocalizationValidity(ApplicationLocalization.class, Period.class, String.class)"});
        }
    }
}

