/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.fwk.tools.usermanagement;

import com.anaptecs.jeaf.application.base.JEAFApplication;
import com.anaptecs.jeaf.core.annotations.JEAFService;
import com.anaptecs.jeaf.services.usermanagement.Authorization;
import com.anaptecs.jeaf.services.usermanagement.AuthorizationAdminService;
import com.anaptecs.jeaf.services.usermanagement.AuthorizationType;
import com.anaptecs.jeaf.services.usermanagement.RoleDefinition;
import com.anaptecs.jeaf.services.usermanagement.UserManagementServiceApplicationException;
import com.anaptecs.jeaf.tools.api.Tools;
import com.anaptecs.jeaf.xfun.api.checks.Check;
import com.anaptecs.jeaf.xfun.types.Period;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.LoginException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AuthorizationRoleDefinitionImportTool
extends JEAFApplication {
    @JEAFService
    private AuthorizationAdminService authorizationAdminService;
    public static final String DTD_NAME = "AuthorizationData.dtd";

    public static void main(String[] args) {
        try {
            AuthorizationRoleDefinitionImportTool lImporter = new AuthorizationRoleDefinitionImportTool(true);
            int lExitCode = lImporter.start(args);
            System.exit(lExitCode);
        }
        catch (LoginException e) {
            e.printStackTrace();
        }
    }

    public AuthorizationRoleDefinitionImportTool(boolean pInitializeJEAF) throws LoginException {
        super(pInitializeJEAF);
    }

    protected boolean hasFileInput() {
        return true;
    }

    protected boolean hasFileOutput() {
        return false;
    }

    protected void printUsage() {
    }

    protected List<String> getSupportedExtensions() {
        ArrayList<String> lExtensions = new ArrayList<String>();
        lExtensions.add(".xml");
        return lExtensions;
    }

    protected void runApplication(List<String> pInputFileNames, String pOutputDirectoryName, Map<String, String> pOptions) throws UserManagementServiceApplicationException, ParserConfigurationException, SAXException, IOException {
        for (String lFileName : pInputFileNames) {
            this.runImportTool(lFileName);
        }
    }

    public void runImportTool(String pFileName) throws UserManagementServiceApplicationException, ParserConfigurationException, SAXException, IOException {
        Check.checkInvalidParameterNull((Object)pFileName, (String)"pFileName");
        List<RoleDefinition> lRoleDefinitions = this.getRoleDefinitionListFromXML(pFileName);
        this.authorizationAdminService.synchronizeRolesAndAuthorizations(lRoleDefinitions);
    }

    private List<RoleDefinition> getRoleDefinitionListFromXML(String pFileName) throws ParserConfigurationException, SAXException, IOException {
        Check.checkInvalidParameterNull((Object)pFileName, (String)"pFileName");
        ArrayList<RoleDefinition> lRoleDefinitions = new ArrayList<RoleDefinition>();
        URL lMessageDTDLocation = Tools.getFileTools().locateResourceURL(DTD_NAME);
        String lSystemID = lMessageDTDLocation.toExternalForm();
        Document lDOMDocument = Tools.getXMLTools().parseFile(pFileName, true, lSystemID);
        NodeList lNodes = lDOMDocument.getElementsByTagName("RoleDefinition");
        for (int i = 0; i < lNodes.getLength(); ++i) {
            ArrayList<String> lAuthTypeNames = new ArrayList<String>();
            Node lNode = lNodes.item(i);
            NamedNodeMap lAttributeNodes = lNode.getAttributes();
            Node lAttrNode = lAttributeNodes.item(0);
            String lDefinitionName = lAttrNode.getNodeValue();
            NodeList lChildNodes = lNode.getChildNodes();
            for (int k = 0; k < lChildNodes.getLength(); ++k) {
                Node lChildNode = lChildNodes.item(k);
                NamedNodeMap lChildAttributeNodes = lChildNode.getAttributes();
                if (lChildAttributeNodes == null) continue;
                for (int j = 0; j < lChildAttributeNodes.getLength(); ++j) {
                    Node lChildAttrNode = lChildAttributeNodes.item(j);
                    String lAuthorizationName = lChildAttrNode.getNodeValue();
                    lAuthTypeNames.add(lAuthorizationName);
                }
            }
            RoleDefinition lRoleDefinition = RoleDefinition.Builder.newBuilder().build();
            lRoleDefinition.setName(lDefinitionName);
            for (String lName : lAuthTypeNames) {
                AuthorizationType lAuthorizationType = AuthorizationType.Builder.newBuilder().build();
                lAuthorizationType.setName(lName);
                Authorization lAuthorization = Authorization.Builder.newBuilder().build();
                lAuthorization.setValidity(Period.UNLIMITED_PERIOD);
                lAuthorization.setAuthorizationType(lAuthorizationType);
                lRoleDefinition.addToAuthorizations(lAuthorization);
            }
            lRoleDefinitions.add(lRoleDefinition);
        }
        return lRoleDefinitions;
    }
}

