/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.fwk.tools.usermanagement;

import com.anaptecs.jeaf.application.base.JEAFApplication;
import com.anaptecs.jeaf.core.api.JEAF;
import com.anaptecs.jeaf.services.usermanagement.AuthorizationAdminService;
import com.anaptecs.jeaf.services.usermanagement.CommunicationAddress;
import com.anaptecs.jeaf.services.usermanagement.Permission;
import com.anaptecs.jeaf.services.usermanagement.Person;
import com.anaptecs.jeaf.services.usermanagement.PostalAddress;
import com.anaptecs.jeaf.services.usermanagement.RoleAssociation;
import com.anaptecs.jeaf.services.usermanagement.RoleDefinition;
import com.anaptecs.jeaf.services.usermanagement.UserAccount;
import com.anaptecs.jeaf.services.usermanagement.UserManagementAdminService;
import com.anaptecs.jeaf.services.usermanagement.UserManagementMessages;
import com.anaptecs.jeaf.services.usermanagement.UserManagementService;
import com.anaptecs.jeaf.services.usermanagement.UserManagementServiceApplicationException;
import com.anaptecs.jeaf.spi.identity.AccountType;
import com.anaptecs.jeaf.tools.api.Tools;
import com.anaptecs.jeaf.xfun.api.checks.Check;
import com.anaptecs.jeaf.xfun.api.errorhandling.ErrorCode;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFApplicationException;
import com.anaptecs.jeaf.xfun.types.Gender;
import com.anaptecs.jeaf.xfun.types.Period;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.LoginException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UserAccountImportTool
extends JEAFApplication {
    private UserManagementAdminService userManagementAdminService = (UserManagementAdminService)JEAF.getService(UserManagementAdminService.class);
    private AuthorizationAdminService authorizationAdminService = (AuthorizationAdminService)JEAF.getService(AuthorizationAdminService.class);
    private UserManagementService userManagementService = (UserManagementService)JEAF.getService(UserManagementService.class);
    public static final String DTD_NAME = "UserAccountData.dtd";
    public static final String UPDATE_EXISTING = "UpdateExistingUserAccounts";

    public static void main(String[] args) {
        try {
            UserAccountImportTool lImportTool = new UserAccountImportTool(true);
            lImportTool.start(args);
        }
        catch (LoginException e) {
            e.printStackTrace();
        }
    }

    public UserAccountImportTool(boolean pInitializeJEAF) throws LoginException {
        super(pInitializeJEAF);
    }

    private void runImportTool(String pFileName, boolean pSkipUserAccounts) throws UserManagementServiceApplicationException, JEAFApplicationException, ParserConfigurationException, SAXException, IOException {
        Check.checkInvalidParameterNull((Object)pFileName, (String)"pFileName");
        Check.checkInvalidParameterNull((Object)pSkipUserAccounts, (String)"pSkipUserAccounts");
        Set<UserAccount> lUserAccounts = this.getUserAccountsWithRolesAndPersonFromXML(pFileName);
        this.userManagementAdminService.importUserAccounts(lUserAccounts, pSkipUserAccounts);
    }

    private Set<UserAccount> getUserAccountsWithRolesAndPersonFromXML(String pFileName) throws IOException, JEAFApplicationException {
        Check.checkInvalidParameterNull((Object)pFileName, (String)"pFileName");
        HashSet<UserAccount> lResult = new HashSet<UserAccount>();
        List lRoleDefinitions = this.authorizationAdminService.getAllRoleDefinitions();
        URL lMessageDTDLocation = Tools.getFileTools().locateResourceURL(DTD_NAME);
        String lSystemID = lMessageDTDLocation.toExternalForm();
        Document lDOMDocument = Tools.getXMLTools().parseFile(pFileName, true, lSystemID);
        NodeList lNodes = lDOMDocument.getElementsByTagName("UserAccount");
        for (int i = 0; i < lNodes.getLength(); ++i) {
            ArrayList<String> lRoleDefinitionNames = new ArrayList<String>();
            Node lNode = lNodes.item(i);
            NamedNodeMap lAttributeNodes = lNode.getAttributes();
            String lLoginName = "";
            for (int l = 0; l < lAttributeNodes.getLength(); ++l) {
                Node lAttrNode = lAttributeNodes.item(l);
                if (!lAttrNode.getNodeName().equals("loginName")) continue;
                lLoginName = lAttrNode.getNodeValue();
            }
            Person lPerson = this.getPersonFromXML(lAttributeNodes);
            NodeList lChildNodes = lNode.getChildNodes();
            for (int k = 0; k < lChildNodes.getLength(); ++k) {
                Node lChildNode = lChildNodes.item(k);
                NamedNodeMap lChildAttributeNodes = lChildNode.getAttributes();
                if (lChildAttributeNodes == null) continue;
                for (int j = 0; j < lChildAttributeNodes.getLength(); ++j) {
                    Node lChildAttrNode = lChildAttributeNodes.item(j);
                    String lRoleDefinitionName = lChildAttrNode.getNodeValue();
                    lRoleDefinitionNames.add(lRoleDefinitionName);
                }
            }
            UserAccount lCreatedUser = this.createUserAccountWithRoleAssociation(lLoginName, lRoleDefinitionNames, lRoleDefinitions, lPerson);
            lResult.add(lCreatedUser);
        }
        return lResult;
    }

    private Person getPersonFromXML(NamedNodeMap pAttributeNodes) throws JEAFApplicationException {
        Person lCreatedPerson = Person.Builder.newBuilder().build();
        for (int j = 0; j < pAttributeNodes.getLength(); ++j) {
            Node lAttrNode = pAttributeNodes.item(j);
            if (lAttrNode.getNodeName().equals("name")) {
                lCreatedPerson.setName(lAttrNode.getNodeValue());
                continue;
            }
            if (lAttrNode.getNodeName().equals("firstName")) {
                lCreatedPerson.setFirstName(lAttrNode.getNodeValue());
                continue;
            }
            if (lAttrNode.getNodeName().equals("dateOfBirth")) {
                Date lDate;
                String lDateOfBirth = lAttrNode.getNodeValue();
                try {
                    SimpleDateFormat sdfToDate = new SimpleDateFormat("dd.MM.yyyy");
                    lDate = sdfToDate.parse(lDateOfBirth);
                }
                catch (ParseException ex2) {
                    throw new JEAFApplicationException(UserManagementMessages.UNABLE_TO_PARSE_DATE_STRING, (Throwable)ex2, new String[0]);
                }
                lCreatedPerson.setDateOfBirth(lDate);
                continue;
            }
            if (lAttrNode.getNodeName().equals("language")) {
                lCreatedPerson.setLanguage(new Locale(lAttrNode.getNodeValue()));
                continue;
            }
            if (lAttrNode.getNodeName().equals("gender")) {
                String lGender = lAttrNode.getNodeValue();
                if (lGender.equals("MALE")) {
                    lCreatedPerson.setGender(Gender.MALE);
                    continue;
                }
                if (lGender.equals("FEMALE")) {
                    lCreatedPerson.setGender(Gender.FEMALE);
                    continue;
                }
                lCreatedPerson.setGender(Gender.UNKNOWN);
                continue;
            }
            if (!lAttrNode.getNodeName().equals("eMailAddress")) continue;
            CommunicationAddress lCommunicationAddress = CommunicationAddress.Builder.newBuilder().build();
            lCommunicationAddress.setAddressType(this.userManagementService.getAddressType("Email"));
            lCommunicationAddress.setAddressSubtype(this.userManagementService.getAddressSybtype("Private", "Email"));
            lCommunicationAddress.setAddressValue(lAttrNode.getNodeValue());
            lCreatedPerson.setMainEMailAddress(lCommunicationAddress);
        }
        PostalAddress lMainAddress = PostalAddress.Builder.newBuilder().build();
        lMainAddress.setAddressType(this.userManagementService.getAddressType("Postal Address"));
        lMainAddress.setStreet("");
        lMainAddress.setCity("");
        lCreatedPerson.setMainAddress(lMainAddress);
        return lCreatedPerson;
    }

    private UserAccount createUserAccountWithRoleAssociation(String pLoginName, List<String> pRoleDefinitionNames, List<RoleDefinition> pRoleDefinitions, Person pPerson) throws JEAFApplicationException {
        UserAccount lCreatedUser = UserAccount.Builder.newBuilder().build();
        lCreatedUser.setLocked(Boolean.valueOf(false));
        lCreatedUser.setPasswordExpiration((Calendar)new GregorianCalendar(2030, 11, 31));
        lCreatedUser.setLoginName(pLoginName);
        lCreatedUser.setAccountType(AccountType.Consumer);
        for (String lRoleName : pRoleDefinitionNames) {
            boolean lRoleDeifnitionExists = false;
            for (RoleDefinition lRoleDefinition : pRoleDefinitions) {
                if (!lRoleDefinition.getName().equals(lRoleName)) continue;
                lRoleDeifnitionExists = true;
                RoleAssociation lRoleAssociation = RoleAssociation.Builder.newBuilder().build();
                lRoleAssociation.setInheritable(Boolean.TRUE);
                lRoleAssociation.setComment("Created during Import");
                lRoleAssociation.setRoleDefinition(lRoleDefinition);
                lRoleAssociation.setValidity(new Period((Date)null, (Date)null));
                lCreatedUser.addToAssignedPermissions((Permission)lRoleAssociation);
            }
            if (lRoleDeifnitionExists) continue;
            ErrorCode lErrorCode = UserManagementMessages.ROLEDEFINITION_DOES_NOT_EXIST;
            throw new JEAFApplicationException(lErrorCode, new String[]{lRoleName});
        }
        lCreatedUser.setPerson(pPerson);
        if (pPerson == null) {
            throw new JEAFApplicationException(UserManagementMessages.UNABLE_TO_CREATE_USER_ACCOUNT);
        }
        lCreatedUser.setPerson(pPerson);
        return lCreatedUser;
    }

    protected void runApplication(List<String> pInputFileNames, String pOutputDirectoryName, Map<String, String> pOptions) throws UserManagementServiceApplicationException, JEAFApplicationException, ParserConfigurationException, SAXException, IOException {
        boolean lIgnoreExisting = pOptions.containsKey(UPDATE_EXISTING.toLowerCase());
        for (int i = 0; i < pInputFileNames.size(); ++i) {
            String lFileName = pInputFileNames.get(i);
            this.runImportTool(lFileName, lIgnoreExisting);
        }
    }

    protected boolean hasFileInput() {
        return true;
    }

    protected boolean hasFileOutput() {
        return false;
    }

    protected void printUsage() {
    }

    protected List<String> getSupportedExtensions() {
        ArrayList<String> lExtensions = new ArrayList<String>();
        lExtensions.add(".xml");
        return lExtensions;
    }
}

