/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.xfun.impl.checks;

import com.anaptecs.jeaf.api.xfun.XFunMessages;
import com.anaptecs.jeaf.tools.api.Tools;
import com.anaptecs.jeaf.tools.api.date.DateTools;
import com.anaptecs.jeaf.xfun.api.XFun;
import com.anaptecs.jeaf.xfun.api.checks.Check;
import com.anaptecs.jeaf.xfun.api.checks.Verifier;
import com.anaptecs.jeaf.xfun.api.errorhandling.ErrorCode;
import com.anaptecs.jeaf.xfun.api.errorhandling.FailureMessage;
import com.anaptecs.jeaf.xfun.api.messages.MessageID;
import java.util.Collection;
import java.util.Date;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class VerifierImpl
implements Verifier {
    private static ErrorCode verificationIsNotNullErrorCode;
    private static ErrorCode verificationIsZeroOrGreaterErrorCode;

    private static synchronized ErrorCode getErrorCodeForVerificationIsNotNull() {
        if (verificationIsNotNullErrorCode == null) {
            verificationIsNotNullErrorCode = XFun.getMessageRepository().getErrorCode(1);
        }
        return verificationIsNotNullErrorCode;
    }

    private static synchronized ErrorCode getErrorCodeForVerificationIsZeroOrGreater() {
        if (verificationIsZeroOrGreaterErrorCode == null) {
            verificationIsZeroOrGreaterErrorCode = XFun.getMessageRepository().getErrorCode(2);
        }
        return verificationIsZeroOrGreaterErrorCode;
    }

    protected final FailureMessage createVerificationFailure(MessageID pMessageID, String[] pMessageParameters) {
        return new FailureMessage(pMessageID, pMessageParameters, null);
    }

    protected final FailureMessage createFailureMessage(MessageID pMessageID, String[] pMessageParameters, Throwable pCause) {
        Check.checkInvalidParameterNull((Object)pMessageID, (String)"pMessageID");
        return new FailureMessage(pMessageID, pMessageParameters, pCause);
    }

    public final FailureMessage isNotNull(Object pObject, String pObjectName) {
        FailureMessage lVerificationFailure;
        if (pObject != null) {
            lVerificationFailure = null;
        } else {
            String[] lParams = new String[]{pObjectName};
            ErrorCode lErrorCode = VerifierImpl.getErrorCodeForVerificationIsNotNull();
            lVerificationFailure = this.createFailureMessage((MessageID)lErrorCode, lParams, null);
        }
        return lVerificationFailure;
    }

    public final FailureMessage isZeroOrGreater(int pValue, String pValueName) {
        FailureMessage lVerificationFailure;
        if (pValue >= 0) {
            lVerificationFailure = null;
        } else {
            String[] lParams = new String[]{pValueName, Integer.toString(pValue)};
            ErrorCode lErrorCode = VerifierImpl.getErrorCodeForVerificationIsZeroOrGreater();
            lVerificationFailure = this.createFailureMessage((MessageID)lErrorCode, lParams, null);
        }
        return lVerificationFailure;
    }

    public final FailureMessage isNull(Object pObject, String pObjectName) {
        FailureMessage lFailureMessage;
        if (pObject == null) {
            lFailureMessage = null;
        } else {
            String[] lParams = new String[]{pObjectName};
            lFailureMessage = this.createFailureMessage((MessageID)XFunMessages.IS_NULL, lParams, null);
        }
        return lFailureMessage;
    }

    public final FailureMessage isTrue(boolean pCondition, String pDescription) {
        FailureMessage lFailureMessage;
        if (pCondition) {
            lFailureMessage = null;
        } else {
            String[] lParams = new String[]{pDescription};
            lFailureMessage = this.createFailureMessage((MessageID)XFunMessages.NOT_TRUE, lParams, null);
        }
        return lFailureMessage;
    }

    public final FailureMessage isFalse(boolean pCondition, String pDescription) {
        FailureMessage lFailureMessage;
        if (!pCondition) {
            lFailureMessage = null;
        } else {
            String[] lParams = new String[]{pDescription};
            lFailureMessage = this.createFailureMessage((MessageID)XFunMessages.NOT_FALSE, lParams, null);
        }
        return lFailureMessage;
    }

    public final FailureMessage isRealString(String pString, String pStringName) {
        FailureMessage lFailureMessage = null;
        if (pString != null) {
            String lTrimmedString = pString.trim();
            if (lTrimmedString.length() == 0) {
                String[] lParams = new String[]{pStringName};
                lFailureMessage = this.createVerificationFailure((MessageID)XFunMessages.STRING_IS_EMPTY, lParams);
            }
        } else {
            String[] lParams = new String[]{pStringName};
            lFailureMessage = this.createVerificationFailure((MessageID)XFunMessages.NULL_IS_NOT_A_REAL_STRING, lParams);
        }
        return lFailureMessage;
    }

    public final FailureMessage verifyMaxStringLength(String pString, int pMaxLenght, String pStringName) {
        Check.checkInvalidParameterNull((Object)pString, (String)"pString");
        FailureMessage lFailureMessage = null;
        if (pString.length() > pMaxLenght) {
            String[] lParams = new String[]{pString, Integer.toString(pMaxLenght)};
            lFailureMessage = this.createVerificationFailure((MessageID)XFunMessages.STRING_TOO_LONG, lParams);
        }
        return lFailureMessage;
    }

    public final FailureMessage isValidSet(int pLowerBound, int pUpperBound) {
        FailureMessage lFailureMessage;
        if (pLowerBound <= pUpperBound) {
            lFailureMessage = null;
        } else {
            String[] lParams = new String[]{Integer.toString(pLowerBound), Integer.toString(pUpperBound)};
            ErrorCode lErrorCode = XFunMessages.SET_IS_INVALID;
            lFailureMessage = this.createVerificationFailure((MessageID)lErrorCode, lParams);
        }
        return lFailureMessage;
    }

    public final FailureMessage isPartOfSet(int pLowerBound, int pUpperBound, int pValue) {
        FailureMessage lFailureMessage = this.isValidSet(pLowerBound, pUpperBound);
        if (lFailureMessage == null) {
            if (pLowerBound <= pValue && pValue <= pUpperBound) {
                lFailureMessage = null;
            } else {
                String[] lParams = new String[]{Integer.toString(pValue), Integer.toString(pLowerBound), Integer.toString(pUpperBound)};
                lFailureMessage = this.createVerificationFailure((MessageID)XFunMessages.VALUE_IS_NOT_PART_OF_SET, lParams);
            }
        }
        return lFailureMessage;
    }

    public final FailureMessage isNotPartOfSet(int pLowerBound, int pUpperBound, int pValue) {
        FailureMessage lFailureMessage = this.isValidSet(pLowerBound, pUpperBound);
        if (lFailureMessage == null) {
            if (pValue < pLowerBound || pValue > pUpperBound) {
                lFailureMessage = null;
            } else {
                String[] lParams = new String[]{Integer.toString(pValue), Integer.toString(pLowerBound), Integer.toString(pUpperBound)};
                lFailureMessage = this.createVerificationFailure((MessageID)XFunMessages.VALUE_IS_PART_OF_SET, lParams);
            }
        }
        return lFailureMessage;
    }

    public final FailureMessage isSubset(int pLowerBoundSet, int pUpperBoundSet, int pLowerBoundSubset, int pUpperBoundSubset) {
        FailureMessage lFailureMessage = this.isValidSet(pLowerBoundSet, pUpperBoundSet);
        if (lFailureMessage == null && (lFailureMessage = this.isValidSet(pLowerBoundSubset, pUpperBoundSubset)) == null && (pLowerBoundSubset < pLowerBoundSet || pUpperBoundSubset > pUpperBoundSet)) {
            String[] lParams = new String[]{Integer.toString(pLowerBoundSet), Integer.toString(pUpperBoundSet), Integer.toString(pLowerBoundSubset), Integer.toString(pUpperBoundSubset)};
            lFailureMessage = this.createVerificationFailure((MessageID)XFunMessages.INVALID_SUBSET, lParams);
        }
        return lFailureMessage;
    }

    public final FailureMessage hasIntersection(int pLowerBoundFirstSet, int pUpperBoundFirstSet, int pLowerBoundSecondSet, int pUpperBoundSecondSet) {
        FailureMessage lFailureMessage = this.isValidSet(pLowerBoundFirstSet, pUpperBoundFirstSet);
        if (lFailureMessage == null && (lFailureMessage = this.isValidSet(pLowerBoundSecondSet, pUpperBoundSecondSet)) == null && (pUpperBoundFirstSet < pLowerBoundSecondSet || pUpperBoundSecondSet < pLowerBoundFirstSet)) {
            String[] lParams = new String[]{Integer.toString(pLowerBoundFirstSet), Integer.toString(pUpperBoundFirstSet), Integer.toString(pLowerBoundSecondSet), Integer.toString(pUpperBoundSecondSet)};
            lFailureMessage = this.createVerificationFailure((MessageID)XFunMessages.SETS_HAVE_NO_INTERSECTION, lParams);
        }
        return lFailureMessage;
    }

    public final FailureMessage hasEmptyIntersection(int pLowerBoundFirstSet, int pUpperBoundFirstSet, int pLowerBoundSecondSet, int pUpperBoundSecondSet) {
        FailureMessage lFailureMessage = this.isValidSet(pLowerBoundFirstSet, pUpperBoundFirstSet);
        if (lFailureMessage == null && (lFailureMessage = this.isValidSet(pLowerBoundSecondSet, pUpperBoundSecondSet)) == null) {
            if (pUpperBoundFirstSet < pLowerBoundSecondSet || pUpperBoundSecondSet < pLowerBoundFirstSet) {
                lFailureMessage = null;
            } else {
                String[] lParams = new String[]{Integer.toString(pLowerBoundFirstSet), Integer.toString(pUpperBoundFirstSet), Integer.toString(pLowerBoundSecondSet), Integer.toString(pUpperBoundSecondSet)};
                lFailureMessage = this.createVerificationFailure((MessageID)XFunMessages.SETS_HAVE_NO_INTERSECTION, lParams);
            }
        }
        return lFailureMessage;
    }

    public final FailureMessage verifyPattern(String pCharacters, String pPattern) {
        FailureMessage lFailureMessage;
        Check.checkInvalidParameterNull((Object)pCharacters, (String)"pCharacters");
        Check.checkInvalidParameterNull((Object)pPattern, (String)"pPattern");
        boolean lPatternFullfilled = Tools.getRegExpTools().matchesPattern(pCharacters, pPattern);
        if (lPatternFullfilled) {
            lFailureMessage = null;
        } else {
            String[] lParams = new String[]{pCharacters, pPattern};
            lFailureMessage = this.createFailureMessage((MessageID)XFunMessages.PATTERN_NOT_MATCHED, lParams, null);
        }
        return lFailureMessage;
    }

    public final FailureMessage verifyMinimumCollectionSize(Collection<?> pCollection, int pMinimumSize) {
        FailureMessage lFailureMessage;
        Check.checkInvalidParameterNull(pCollection, (String)"pCollection");
        if (pCollection.size() >= pMinimumSize) {
            lFailureMessage = null;
        } else {
            String[] lParams = new String[]{Integer.toString(pMinimumSize)};
            lFailureMessage = this.createVerificationFailure((MessageID)XFunMessages.COLLECTION_DOES_NOT_HAVE_MIN_SIZE, lParams);
        }
        return lFailureMessage;
    }

    public final FailureMessage verifyMaximumCollectionSize(Collection<?> pCollection, int pMaximumSize) {
        FailureMessage lFailureMessage;
        Check.checkInvalidParameterNull(pCollection, (String)"pCollection");
        if (pCollection.size() <= pMaximumSize) {
            lFailureMessage = null;
        } else {
            String[] lParams = new String[]{Integer.toString(pMaximumSize)};
            lFailureMessage = this.createVerificationFailure((MessageID)XFunMessages.COLLECTION_EXCEEDS_MAX_SIZE, lParams);
        }
        return lFailureMessage;
    }

    public final FailureMessage verifyValidPeriod(Date pStart, Date pEnd) {
        FailureMessage lFailureMessage;
        if (pStart == null || pEnd == null) {
            lFailureMessage = null;
        } else if (pStart.before(pEnd)) {
            lFailureMessage = null;
        } else {
            DateTools lDateTools = Tools.getDateTools();
            String[] lParams = new String[]{lDateTools.toTimestampString(pStart), lDateTools.toDateString(pEnd)};
            lFailureMessage = this.createFailureMessage((MessageID)XFunMessages.INVALID_PERIOD, lParams, null);
        }
        return lFailureMessage;
    }

    public final FailureMessage verifyEMailAddress(String pEMailAddress) {
        FailureMessage lFailureMessage;
        if (pEMailAddress != null) {
            try {
                InternetAddress lEmailAddress = new InternetAddress(pEMailAddress);
                lEmailAddress.validate();
                lFailureMessage = null;
            }
            catch (AddressException e) {
                lFailureMessage = this.createFailureMessage((MessageID)XFunMessages.INVALID_EMAIL_ADDRESS, null, e);
            }
        } else {
            lFailureMessage = this.createFailureMessage((MessageID)XFunMessages.INVALID_EMAIL_ADDRESS, null, null);
        }
        return lFailureMessage;
    }
}

