/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.xfun.impl.config;

import com.anaptecs.jeaf.api.xfun.XFunMessages;
import com.anaptecs.jeaf.xfun.api.XFun;
import com.anaptecs.jeaf.xfun.api.checks.Assert;
import com.anaptecs.jeaf.xfun.api.checks.Check;
import com.anaptecs.jeaf.xfun.api.config.Configuration;
import com.anaptecs.jeaf.xfun.api.config.ConfigurationResource;
import com.anaptecs.jeaf.xfun.api.datatypeconverter.DatatypeConverter;
import com.anaptecs.jeaf.xfun.api.datatypeconverter.DatatypeConverterRegistry;
import com.anaptecs.jeaf.xfun.api.messages.MessageID;
import com.anaptecs.jeaf.xfun.api.trace.Trace;
import com.anaptecs.jeaf.xfun.impl.config.SystemPropertiesHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import java.util.StringTokenizer;

public class ConfigurationImpl
implements Configuration {
    private final ConfigurationResource configurationResource;

    public ConfigurationImpl(ConfigurationResource pConfigurationResource) {
        Check.checkInvalidParameterNull((Object)pConfigurationResource, (String)"pConfigurationResource");
        this.configurationResource = pConfigurationResource;
    }

    public <T> T getConfigurationValue(String pConfigurationKey, Class<T> pType) {
        return this.getConfigurationValue(pConfigurationKey, (T)false, pType);
    }

    public <T> T getConfigurationValue(String pConfigurationKey, boolean pRequired, Class<T> pType) throws MissingResourceException {
        T lConfigurationValue;
        Check.checkInvalidParameterNull((Object)pConfigurationKey, (String)"pConfigurationKey");
        Check.checkInvalidParameterNull(pType, (String)"pType");
        if (this.configurationResource.hasConfigurationValue(pConfigurationKey)) {
            lConfigurationValue = this.resolveConfigurationValue(pConfigurationKey, pRequired, pType);
        } else if (!pRequired) {
            lConfigurationValue = null;
        } else {
            throw this.createMissingResourceException(pConfigurationKey);
        }
        return lConfigurationValue;
    }

    private <T> T resolveConfigurationValue(String pConfigurationKey, boolean pRequired, Class<T> pType) {
        Object lConfigurationValue;
        String lValue = this.getValueFromConfigurationResource(pConfigurationKey);
        if (lValue != null) {
            if (pType.isEnum()) {
                Class<T> lEnumType = pType;
                lConfigurationValue = Enum.valueOf(lEnumType, lValue);
            } else {
                DatatypeConverter lConverter = XFun.getDatatypeConverterRegistry().getConverter(String.class, pType);
                lConfigurationValue = lConverter.convert((Object)lValue);
            }
        } else if (!pRequired) {
            lConfigurationValue = null;
        } else {
            throw this.createMissingResourceException(pConfigurationKey);
        }
        return (T)lConfigurationValue;
    }

    public <T> T getConfigurationValue(String pConfigurationKey, T pDefaultValue, Class<T> pType) {
        Object lConfigurationValue;
        try {
            lConfigurationValue = this.getConfigurationValue(pConfigurationKey, (T)false, pType);
        }
        catch (RuntimeException e) {
            String lMessage = "Exception occured when trying to resolve configuration value '" + pConfigurationKey + " as " + pType.getName();
            XFun.getTrace().error(lMessage, (Throwable)e);
            lConfigurationValue = null;
        }
        if (lConfigurationValue == null) {
            lConfigurationValue = pDefaultValue;
        }
        return lConfigurationValue;
    }

    public <T> List<T> getConfigurationValueList(String pConfigurationKey, Class<T> pType) {
        return this.getConfigurationValueList(pConfigurationKey, (T)false, pType);
    }

    public <T> List<T> getConfigurationValueList(String pConfigurationKey, boolean pRequired, Class<T> pType) throws MissingResourceException {
        List lConfigurationValues;
        Check.checkInvalidParameterNull((Object)pConfigurationKey, (String)"pConfigurationKey");
        Check.checkInvalidParameterNull(pType, (String)"pType");
        if (this.configurationResource.hasConfigurationValue(pConfigurationKey)) {
            lConfigurationValues = this.resolveConfigurationValueList(pConfigurationKey, pRequired, pType);
        } else if (!pRequired) {
            lConfigurationValues = Collections.emptyList();
        } else {
            throw this.createMissingResourceException(pConfigurationKey);
        }
        return lConfigurationValues;
    }

    private <T> List<T> resolveConfigurationValueList(String pConfigurationKey, boolean pRequired, Class<T> pType) {
        List lConfigurationValues;
        List<String> lRawValues = this.getValueListFromConfigurationResource(pConfigurationKey);
        if (!lRawValues.isEmpty()) {
            lConfigurationValues = new ArrayList(lRawValues.size());
            if (pType.isEnum()) {
                Class<T> lEnumType = pType;
                for (String lNextRawValue : lRawValues) {
                    lConfigurationValues.add(Enum.valueOf(lEnumType, lNextRawValue));
                }
            } else {
                DatatypeConverterRegistry lRegistry = XFun.getDatatypeConverterRegistry();
                DatatypeConverter lConverter = lRegistry.getConverter(String.class, pType);
                for (String lNextRawValue : lRawValues) {
                    lConfigurationValues.add(lConverter.convert((Object)lNextRawValue));
                }
            }
        } else if (!pRequired) {
            lConfigurationValues = Collections.emptyList();
        } else {
            throw this.createMissingResourceException(pConfigurationKey);
        }
        return lConfigurationValues;
    }

    public <T> List<T> getConfigurationValueList(String pConfigurationKey, T pDefaultValue, Class<T> pType) {
        List<boolean> lConfigurationValues = this.getConfigurationValueList(pConfigurationKey, (T)false, pType);
        if (lConfigurationValues.isEmpty() && pDefaultValue != null) {
            lConfigurationValues = new ArrayList<boolean>(1);
            lConfigurationValues.add((boolean)pDefaultValue);
        }
        return lConfigurationValues;
    }

    public <T> List<T> getConfigurationValueList(String pConfigurationKey, List<T> pDefaultValue, Class<T> pType) {
        List<Object> lConfigurationValues = this.getConfigurationValueList(pConfigurationKey, (T)false, pType);
        if (lConfigurationValues.isEmpty() && pDefaultValue != null) {
            lConfigurationValues = pDefaultValue;
        }
        return lConfigurationValues;
    }

    public final void writeTrace() {
        Trace lTrace = XFun.getTrace();
        if (XFunMessages.LOADING_JEAF_PROPERTIES.isEnabled()) {
            lTrace.write(XFunMessages.LOADING_JEAF_PROPERTIES, new String[]{this.configurationResource.getResourceName()});
            lTrace.write(XFunMessages.PROPERTIES_LOCATION, new String[]{this.configurationResource.getResourceLocation()});
            List lKeys = this.configurationResource.getAllConfigurationKeys();
            Collections.sort(lKeys);
            MessageID lMessageID = XFunMessages.TRACE_PROPERTY_VALUE;
            for (String lNextKey : lKeys) {
                lTrace.write(lMessageID, new String[]{lNextKey, this.getValueFromConfigurationResource(lNextKey)});
            }
        }
    }

    private String getValueFromConfigurationResource(String pConfigurationKey) throws MissingResourceException {
        Assert.assertNotNull((Object)pConfigurationKey, (String)"pPropertyName");
        String lPropertyValue = this.configurationResource.getConfigurationValue(pConfigurationKey);
        if (lPropertyValue != null) {
            lPropertyValue = (lPropertyValue = lPropertyValue.trim()).length() > 0 ? SystemPropertiesHelper.replaceSystemProperties(lPropertyValue) : null;
        }
        return lPropertyValue;
    }

    private List<String> getValueListFromConfigurationResource(String pConfigurationKey) {
        List<String> lValueList;
        String lValue = this.getValueFromConfigurationResource(pConfigurationKey);
        if (lValue != null) {
            StringTokenizer lTokenizer = new StringTokenizer(lValue, ";");
            lValueList = new ArrayList<String>(lTokenizer.countTokens());
            while (lTokenizer.hasMoreTokens()) {
                lValueList.add(lTokenizer.nextToken().trim());
            }
        } else {
            lValueList = Collections.emptyList();
        }
        return lValueList;
    }

    private MissingResourceException createMissingResourceException(String pConfigurationKey) {
        String lResourceName = this.configurationResource.getResourceName();
        Assert.assertNotNull((Object)lResourceName, (String)"lResourceName");
        StringBuilder lMessage = new StringBuilder();
        lMessage.append("Required property with the name '");
        lMessage.append(pConfigurationKey);
        lMessage.append("' is not set.");
        return new MissingResourceException(lMessage.toString(), lResourceName, pConfigurationKey);
    }
}

