/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.xfun.impl.config;

import com.anaptecs.jeaf.xfun.annotations.StartupInfoWriterImpl;
import com.anaptecs.jeaf.xfun.api.XFun;
import com.anaptecs.jeaf.xfun.api.common.ComponentID;
import com.anaptecs.jeaf.xfun.api.config.ComponentConfigurationResourceFactory;
import com.anaptecs.jeaf.xfun.api.config.Configuration;
import com.anaptecs.jeaf.xfun.api.config.ConfigurationProvider;
import com.anaptecs.jeaf.xfun.api.config.ConfigurationResource;
import com.anaptecs.jeaf.xfun.api.config.EnvironmentConfigurationResourceFactory;
import com.anaptecs.jeaf.xfun.api.config.FileConfigurationResourceFactory;
import com.anaptecs.jeaf.xfun.api.config.ResourceBundleConfigurationResourceFactory;
import com.anaptecs.jeaf.xfun.api.config.ResourceConfigurationResourceFactory;
import com.anaptecs.jeaf.xfun.api.config.SystemPropertiesConfigurationResourceFactory;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import com.anaptecs.jeaf.xfun.api.trace.StartupInfoWriter;
import com.anaptecs.jeaf.xfun.api.trace.Trace;
import com.anaptecs.jeaf.xfun.api.trace.TraceLevel;
import com.anaptecs.jeaf.xfun.impl.config.ConfigurationImpl;
import com.anaptecs.jeaf.xfun.impl.config.ConfigurationProviderConfiguration;
import com.anaptecs.jeaf.xfun.impl.config.SystemPropertiesHelper;

@StartupInfoWriterImpl
public final class ConfigurationProviderImpl
implements ConfigurationProvider,
StartupInfoWriter {
    private final ComponentConfigurationResourceFactory componentConfigurationResourceFactory;
    private final EnvironmentConfigurationResourceFactory environmentConfigurationResourceFactory;
    private final FileConfigurationResourceFactory fileConfigurationResourceFactory;
    private final ResourceConfigurationResourceFactory resourceConfigurationResourceFactory;
    private final ResourceBundleConfigurationResourceFactory resourceBundleConfigurationProvider;
    private final SystemPropertiesConfigurationResourceFactory systemPropertiesConfigurationProvider;

    public ConfigurationProviderImpl() {
        ConfigurationProviderConfiguration lConfig = ConfigurationProviderConfiguration.getInstance();
        this.componentConfigurationResourceFactory = lConfig.getComponentConfigurationResourceFactory();
        this.environmentConfigurationResourceFactory = lConfig.getEnvironmentConfigurationResourceFactory();
        this.fileConfigurationResourceFactory = lConfig.getFileConfigurationResourceFactory();
        this.resourceConfigurationResourceFactory = lConfig.getResourceConfigurationResourceFactory();
        this.resourceBundleConfigurationProvider = lConfig.getResourceBundleConfigurationResourceFactory();
        this.systemPropertiesConfigurationProvider = lConfig.getSystemPropertiesConfigurationResourceFactory();
    }

    public Configuration getComponentConfiguration(ComponentID pComponentID) throws JEAFSystemException {
        ConfigurationResource lResource = this.componentConfigurationResourceFactory.getComponentConfigurationResource(pComponentID);
        return new ConfigurationImpl(lResource);
    }

    public Configuration getEnvironmentConfiguration() {
        ConfigurationResource lResource = this.environmentConfigurationResourceFactory.getEnvironmentConfigurationResource();
        return new ConfigurationImpl(lResource);
    }

    public Configuration getFileConfiguration(String pFileName) throws JEAFSystemException {
        ConfigurationResource lResource = this.fileConfigurationResourceFactory.getFileConfigurationResource(pFileName);
        return new ConfigurationImpl(lResource);
    }

    public Configuration getResourceConfiguration(String pResourceName) {
        ConfigurationResource lResource = this.resourceConfigurationResourceFactory.getResourceConfigurationResource(pResourceName);
        return new ConfigurationImpl(lResource);
    }

    public Configuration getResourceBundleConfiguration(String pResourceBundleName) {
        ConfigurationResource lResource = this.resourceBundleConfigurationProvider.getResourceBundleConfigurationResource(pResourceBundleName);
        return new ConfigurationImpl(lResource);
    }

    public Configuration getSystemPropertiesConfiguration() {
        ConfigurationResource lResource = this.systemPropertiesConfigurationProvider.getSystemPropertiesConfigurationResource();
        return new ConfigurationImpl(lResource);
    }

    public String replaceSystemProperties(String pValue) {
        return SystemPropertiesHelper.replaceSystemProperties(pValue);
    }

    public Class<?> getStartupCompletedEventSource() {
        return XFun.class;
    }

    public void traceStartupInfo(Trace pTrace, TraceLevel pTraceLevel) {
        pTrace.writeInitInfo("JEAF X-Fun uses the following configuration providers:", pTraceLevel);
        pTrace.writeInitInfo("Component-Impl:             " + this.componentConfigurationResourceFactory.getClass().getName(), pTraceLevel);
        pTrace.writeInitInfo("Environment-Impl:           " + this.environmentConfigurationResourceFactory.getClass().getName(), pTraceLevel);
        pTrace.writeInitInfo("File-Configuration:         " + this.fileConfigurationResourceFactory.getClass().getName(), pTraceLevel);
        pTrace.writeInitInfo("Resource-Impl:              " + this.resourceConfigurationResourceFactory.getClass().getName(), pTraceLevel);
        pTrace.writeInitInfo("Resource-Bundle-Impl:       " + this.resourceBundleConfigurationProvider.getClass().getName(), pTraceLevel);
        pTrace.writeInitInfo("System-Properties-Impl:     " + this.systemPropertiesConfigurationProvider.getClass().getName(), pTraceLevel);
    }
}

