/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.xfun.impl.config;

import com.anaptecs.jeaf.xfun.api.checks.Check;
import com.anaptecs.jeaf.xfun.api.config.ConfigurationResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;

public final class EnvironmentConfigurationResource
implements ConfigurationResource {
    public static final String OS_ENV_VARIABLES = "OS environment variables";
    private final Map<String, String> environmentVariables = System.getenv();

    public String getResourceName() {
        return OS_ENV_VARIABLES;
    }

    public String getResourceLocation() {
        return OS_ENV_VARIABLES;
    }

    public boolean hasConfigurationValue(String pConfigurationKey) {
        Check.checkInvalidParameterNull((Object)pConfigurationKey, (String)"pConfigurationKey");
        return this.environmentVariables.containsKey(pConfigurationKey);
    }

    public List<String> getAllConfigurationKeys() {
        Set<String> lKeys = this.environmentVariables.keySet();
        return new ArrayList<String>(lKeys);
    }

    public String getConfigurationValue(String pConfigurationKey) throws MissingResourceException {
        Check.checkInvalidParameterNull((Object)pConfigurationKey, (String)"pConfigurationKey");
        if (this.environmentVariables.containsKey(pConfigurationKey)) {
            return this.environmentVariables.get(pConfigurationKey);
        }
        String lMessage = "Environment variable with the name '" + pConfigurationKey + "' is not defined.";
        throw new MissingResourceException(lMessage, OS_ENV_VARIABLES, pConfigurationKey);
    }
}

