/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.xfun.impl.config;

import com.anaptecs.jeaf.xfun.api.checks.Check;
import com.anaptecs.jeaf.xfun.api.config.ConfigurationResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;

public final class FileConfigurationResource
implements ConfigurationResource {
    private final Properties properties;
    private final String fileName;
    private final String fileLocation;

    public FileConfigurationResource(String pFileName) throws IOException {
        Check.checkInvalidParameterNull((Object)pFileName, (String)"pFileName");
        File lFile = new File(pFileName);
        String lCanonicalPath = lFile.getCanonicalPath();
        this.fileName = lFile.getName();
        this.fileLocation = lCanonicalPath;
        try (FileInputStream lFileInputStream = new FileInputStream(lCanonicalPath);){
            this.properties = new Properties();
            this.properties.load(lFileInputStream);
        }
    }

    public String getResourceName() {
        return this.fileName;
    }

    public String getResourceLocation() {
        return this.fileLocation;
    }

    public boolean hasConfigurationValue(String pConfigurationKey) {
        Check.checkInvalidParameterNull((Object)pConfigurationKey, (String)"pConfigurationKey");
        return this.properties.containsKey(pConfigurationKey);
    }

    public List<String> getAllConfigurationKeys() {
        ArrayList<String> lKeys = new ArrayList<String>();
        for (Object lKey : this.properties.keySet()) {
            lKeys.add(lKey.toString());
        }
        return lKeys;
    }

    public String getConfigurationValue(String pConfigurationKey) throws MissingResourceException {
        Check.checkInvalidParameterNull((Object)pConfigurationKey, (String)"pConfigurationKey");
        String lValue = this.properties.getProperty(pConfigurationKey);
        if (lValue != null) {
            return lValue.trim();
        }
        String lMessage = "Environment variable with the name '" + pConfigurationKey + "' is not defined.";
        throw new MissingResourceException(lMessage, this.fileLocation, pConfigurationKey);
    }
}

