/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.xfun.impl.config;

import com.anaptecs.jeaf.xfun.api.checks.Check;
import com.anaptecs.jeaf.xfun.api.config.ConfigurationResource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Set;

public final class PropertiesConfigurationResource
implements ConfigurationResource {
    private final Properties properties;
    private final String resourceName;
    private final String resourceLocation;

    public PropertiesConfigurationResource(String pResourceName) throws MissingResourceException {
        block16: {
            Check.checkInvalidParameterNull((Object)pResourceName, (String)"pResourceName");
            URL lResourceURL = this.getClass().getClassLoader().getResource(pResourceName);
            if (lResourceURL == null) {
                lResourceURL = ClassLoader.getSystemResource(pResourceName);
            }
            if (lResourceURL != null) {
                this.resourceName = pResourceName;
                this.resourceLocation = lResourceURL.toExternalForm();
                this.properties = new Properties();
                try (InputStream lInputStream = lResourceURL.openStream();){
                    this.properties.load(lInputStream);
                    break block16;
                }
                catch (IOException e) {
                    String lMessage = "Unable to read configuration from resource " + pResourceName + ". " + e.getMessage();
                    throw new MissingResourceException(lMessage, pResourceName, null);
                }
            }
            String lMessage = "Unable to read configuration from resource " + pResourceName + ". Resource could not be found.";
            throw new MissingResourceException(lMessage, pResourceName, null);
        }
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getResourceLocation() {
        return this.resourceLocation;
    }

    public boolean hasConfigurationValue(String pConfigurationKey) {
        Check.checkInvalidParameterNull((Object)pConfigurationKey, (String)"pConfigurationKey");
        return this.properties.containsKey(pConfigurationKey);
    }

    public List<String> getAllConfigurationKeys() {
        Set<Object> lKeys = this.properties.keySet();
        ArrayList<String> lKeysAsString = new ArrayList<String>(lKeys.size());
        for (Object lNextKey : lKeys) {
            lKeysAsString.add(lNextKey.toString());
        }
        return lKeysAsString;
    }

    public String getConfigurationValue(String pConfigurationKey) throws MissingResourceException {
        Check.checkInvalidParameterNull((Object)pConfigurationKey, (String)"pConfigurationKey");
        String lValue = this.properties.getProperty(pConfigurationKey);
        if (lValue != null) {
            return lValue.trim();
        }
        String lMessage = "Environment variable with the name '" + pConfigurationKey + "' is not defined.";
        throw new MissingResourceException(lMessage, this.resourceName, pConfigurationKey);
    }
}

