/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.xfun.impl.config;

import com.anaptecs.jeaf.xfun.api.checks.Check;
import com.anaptecs.jeaf.xfun.api.config.ConfigurationResource;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class ResourceBundleConfigurationResource
implements ConfigurationResource {
    private final ResourceBundle resourceBundle;
    private final String resourceBundelName;
    private final String resourceLocation;

    public ResourceBundleConfigurationResource(String pResourceBundelName) throws MissingResourceException {
        Check.checkInvalidParameterNull((Object)pResourceBundelName, (String)"pResourceBundelName");
        this.resourceBundle = ResourceBundle.getBundle(pResourceBundelName);
        this.resourceBundelName = pResourceBundelName;
        String lResourceName = pResourceBundelName.replace('.', '/') + ".properties";
        URL lResourceURL = this.getClass().getResource(lResourceName);
        if (lResourceURL == null) {
            lResourceURL = ClassLoader.getSystemResource(lResourceName);
        }
        this.resourceLocation = lResourceURL != null ? lResourceURL.toExternalForm() : "unknown";
    }

    public String getResourceName() {
        return this.resourceBundelName;
    }

    public String getResourceLocation() {
        return this.resourceLocation;
    }

    public boolean hasConfigurationValue(String pConfigurationKey) {
        Check.checkInvalidParameterNull((Object)pConfigurationKey, (String)"pConfigurationKey");
        return this.resourceBundle.containsKey(pConfigurationKey);
    }

    public List<String> getAllConfigurationKeys() {
        return Collections.list(this.resourceBundle.getKeys());
    }

    public String getConfigurationValue(String pConfigurationKey) throws MissingResourceException {
        Check.checkInvalidParameterNull((Object)pConfigurationKey, (String)"pConfigurationKey");
        String lValue = this.resourceBundle.getString(pConfigurationKey);
        if (lValue != null) {
            lValue = lValue.trim();
        }
        return lValue;
    }
}

