/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.xfun.impl.config;

import com.anaptecs.jeaf.xfun.api.checks.Check;
import com.anaptecs.jeaf.xfun.api.config.ConfigurationResource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;

public final class SystemPropertiesConfigurationResource
implements ConfigurationResource {
    public static final String SYSTEM_PROPERTIES = "JVM system properties";

    public String getResourceName() {
        return SYSTEM_PROPERTIES;
    }

    public String getResourceLocation() {
        return SYSTEM_PROPERTIES;
    }

    public boolean hasConfigurationValue(String pConfigurationKey) {
        Check.checkInvalidParameterNull((Object)pConfigurationKey, (String)"pConfigurationKey");
        return System.getProperties().containsKey(pConfigurationKey);
    }

    public List<String> getAllConfigurationKeys() {
        ArrayList<Object> lKeys = Collections.list(System.getProperties().keys());
        ArrayList<String> lNames = new ArrayList<String>();
        for (Object e : lKeys) {
            lNames.add(e.toString());
        }
        return lNames;
    }

    public String getConfigurationValue(String pConfigurationKey) throws MissingResourceException {
        Check.checkInvalidParameterNull((Object)pConfigurationKey, (String)"pConfigurationKey");
        Properties lSystemProperties = System.getProperties();
        if (lSystemProperties.containsKey(pConfigurationKey)) {
            return lSystemProperties.getProperty(pConfigurationKey);
        }
        String lMessage = "System property with the name '" + pConfigurationKey + "' is not defined.";
        throw new MissingResourceException(lMessage, SYSTEM_PROPERTIES, pConfigurationKey);
    }
}

