/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.xfun.impl.config;

import com.anaptecs.jeaf.xfun.api.XFun;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SystemPropertiesHelper {
    private SystemPropertiesHelper() {
    }

    public static String replaceSystemProperties(String pValue) {
        String lResult;
        if (pValue != null) {
            Set<String> lSystemProperties = SystemPropertiesHelper.detectSystemProperties(pValue);
            lResult = pValue;
            for (String lPropertyName : lSystemProperties) {
                String lPropertyValue = System.getProperty(lPropertyName);
                if (lPropertyValue != null) {
                    lResult = lResult.replaceAll("\\$\\{" + lPropertyName + "\\}", lPropertyValue);
                    continue;
                }
                String lMessage = "Unable to substitue placeholder for system property " + lPropertyName + ". System-Property is not set.";
                XFun.getTrace().warn(lMessage);
            }
        } else {
            lResult = null;
        }
        return lResult;
    }

    private static Set<String> detectSystemProperties(String pValue) {
        Set<String> lSystemProperties;
        if (pValue.length() > 3) {
            lSystemProperties = new HashSet();
            int lCurrentIndex = 0;
            StringBuilder lBuilder = new StringBuilder();
            boolean lDone = false;
            while (!lDone) {
                int lStartIndex = pValue.indexOf("${", lCurrentIndex);
                if (lStartIndex >= 0) {
                    int lEndIndex = pValue.indexOf("}", lStartIndex);
                    if (lEndIndex - 3 > lStartIndex) {
                        String lPropertyName = pValue.substring(lStartIndex + 2, lEndIndex);
                        lSystemProperties.add(lPropertyName);
                        lCurrentIndex = lEndIndex + 1;
                        continue;
                    }
                    lBuilder.append(pValue);
                    lDone = true;
                    continue;
                }
                lBuilder.append(pValue.substring(lCurrentIndex, pValue.length()));
                lDone = true;
            }
        } else {
            lSystemProperties = Collections.emptySet();
        }
        return lSystemProperties;
    }
}

