/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.xfun.impl.datatypeconverter;

import com.anaptecs.jeaf.api.xfun.XFunMessages;
import com.anaptecs.jeaf.xfun.api.checks.Assert;
import com.anaptecs.jeaf.xfun.api.checks.Check;
import com.anaptecs.jeaf.xfun.api.config.ConfigurationReader;
import com.anaptecs.jeaf.xfun.api.datatypeconverter.DatatypeConverter;
import com.anaptecs.jeaf.xfun.api.datatypeconverter.DatatypeConverterRegistry;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFBootstrapException;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.BigDecimalToDoubleDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.BigDecimalToFloatDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.BigDecimalToStringDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.BigIntegerToByteDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.BigIntegerToIntegerDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.BigIntegerToLongDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.BigIntegerToShortDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.BigIntegerToStringDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.BooleanToStringDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.ByteToBigIntegerDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.ByteToCharacterDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.ByteToStringDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.CalendarToDateDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.CalendarToStringDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.CharacterToByteDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.CharacterToIntegerDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.CharacterToLongDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.CharacterToShortDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.CharacterToStringDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.ClassToStringDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.DateToCalendarDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.DateToStringDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.DoubleToBigDecimalDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.DoubleToFloatDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.DoubleToStringDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.FloatToBigDecimalDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.FloatToDoubleDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.FloatToStringDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.IntegerToBigIntegerDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.IntegerToCharacterDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.IntegerToStringDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.LocaleToStringDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.LongToBigIntegerDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.LongToCharacterDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.LongToStringDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.ShortToBigIntegerDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.ShortToCharacterDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.ShortToStringDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.StringToBigDecimalDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.StringToBigIntegerDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.StringToBooleanDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.StringToByteDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.StringToCalendarDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.StringToCharacterDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.StringToClassDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.StringToDateDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.StringToDoubleDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.StringToFloatDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.StringToIntegerDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.StringToLocaleDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.StringToLongDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.StringToShortDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.StringToStringDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.StringToURLDatatypeConverter;
import com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters.URLToStringDatatypeConverter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DatatypeConverterRegistryImpl
implements DatatypeConverterRegistry {
    private Map<String, DatatypeConverter<?, ?>> converters = new HashMap();

    DatatypeConverterRegistryImpl() {
        this.loadDefaultDatatypeConverters();
        this.loadAdditionalConverters();
    }

    public <I, O> DatatypeConverter<I, O> getConverter(Class<I> pInputType, Class<O> pOutputType) {
        Check.checkInvalidParameterNull(pInputType, (String)"pInputType");
        Check.checkInvalidParameterNull(pOutputType, (String)"pOutputType");
        String lKey = this.generateConverterKey(pInputType, pOutputType);
        DatatypeConverter<?, ?> lDatatypeConverter = this.converters.get(lKey);
        if (lDatatypeConverter != null) {
            return lDatatypeConverter;
        }
        String[] lParams = new String[]{pInputType.getName(), pOutputType.getName()};
        throw new JEAFSystemException(XFunMessages.NO_DATATYPE_CONVERTER_DEFINED, lParams);
    }

    private String generateConverterKey(Class<?> pInputType, Class<?> pOutputType) {
        Assert.assertNotNull(pInputType, (String)"pInputType");
        Assert.assertNotNull(pOutputType, (String)"pOutputType");
        String lInputType = pInputType.getName();
        String lOutputType = pOutputType.getName();
        StringBuilder lBuilder = new StringBuilder(lInputType.length() + lOutputType.length() + 1);
        lBuilder.append(lInputType);
        lBuilder.append(';');
        lBuilder.append(lOutputType);
        return lBuilder.toString();
    }

    public void addConverter(DatatypeConverter<?, ?> pConverter) {
        this.addConverter(pConverter, false);
    }

    private void addConverter(DatatypeConverter<?, ?> pConverter, boolean pOverwrite) {
        Assert.assertNotNull(pConverter, (String)"pConverter");
        Class lInputType = pConverter.getInputType();
        Class lOutputType = pConverter.getOutputType();
        String lKey = this.generateConverterKey(lInputType, lOutputType);
        DatatypeConverter<?, ?> lExistingConverter = this.converters.get(lKey);
        if (lExistingConverter == null) {
            this.converters.put(lKey, pConverter);
        } else if (pOverwrite) {
            this.converters.put(lKey, pConverter);
        } else {
            String[] lParams = new String[]{lInputType.getName(), lOutputType.getName(), lExistingConverter.getClass().getName(), pConverter.getClass().getName()};
            throw new JEAFSystemException(XFunMessages.DATATYPE_CONVERTER_ALREADY_EXISTS, lParams);
        }
    }

    private void loadDefaultDatatypeConverters() {
        this.addConverter(new IntegerToStringDatatypeConverter(), false);
        this.addConverter(new BigDecimalToDoubleDatatypeConverter(), false);
        this.addConverter(new BigDecimalToFloatDatatypeConverter(), false);
        this.addConverter(new BigDecimalToStringDatatypeConverter(), false);
        this.addConverter(new BigIntegerToByteDatatypeConverter(), false);
        this.addConverter(new BigIntegerToIntegerDatatypeConverter(), false);
        this.addConverter(new BigIntegerToLongDatatypeConverter(), false);
        this.addConverter(new BigIntegerToShortDatatypeConverter(), false);
        this.addConverter(new BigIntegerToStringDatatypeConverter(), false);
        this.addConverter(new BooleanToStringDatatypeConverter(), false);
        this.addConverter(new ByteToBigIntegerDatatypeConverter(), false);
        this.addConverter(new ByteToCharacterDatatypeConverter(), false);
        this.addConverter(new ByteToStringDatatypeConverter(), false);
        this.addConverter(new CharacterToByteDatatypeConverter(), false);
        this.addConverter(new CharacterToIntegerDatatypeConverter(), false);
        this.addConverter(new CharacterToLongDatatypeConverter(), false);
        this.addConverter(new CharacterToShortDatatypeConverter(), false);
        this.addConverter(new CharacterToStringDatatypeConverter(), false);
        this.addConverter(new DoubleToBigDecimalDatatypeConverter(), false);
        this.addConverter(new DoubleToFloatDatatypeConverter(), false);
        this.addConverter(new DoubleToStringDatatypeConverter(), false);
        this.addConverter(new FloatToBigDecimalDatatypeConverter(), false);
        this.addConverter(new FloatToDoubleDatatypeConverter(), false);
        this.addConverter(new FloatToStringDatatypeConverter(), false);
        this.addConverter(new IntegerToBigIntegerDatatypeConverter(), false);
        this.addConverter(new IntegerToCharacterDatatypeConverter(), false);
        this.addConverter(new LongToBigIntegerDatatypeConverter(), false);
        this.addConverter(new LongToCharacterDatatypeConverter(), false);
        this.addConverter(new LongToStringDatatypeConverter(), false);
        this.addConverter(new ShortToBigIntegerDatatypeConverter(), false);
        this.addConverter(new ShortToCharacterDatatypeConverter(), false);
        this.addConverter(new ShortToStringDatatypeConverter(), false);
        this.addConverter(new StringToBigDecimalDatatypeConverter(), false);
        this.addConverter(new StringToBigIntegerDatatypeConverter(), false);
        this.addConverter(new StringToBooleanDatatypeConverter(), false);
        this.addConverter(new StringToByteDatatypeConverter(), false);
        this.addConverter(new StringToCharacterDatatypeConverter(), false);
        this.addConverter(new StringToDoubleDatatypeConverter(), false);
        this.addConverter(new StringToFloatDatatypeConverter(), false);
        this.addConverter(new StringToIntegerDatatypeConverter(), false);
        this.addConverter(new StringToLongDatatypeConverter(), false);
        this.addConverter(new StringToShortDatatypeConverter(), false);
        this.addConverter(new StringToStringDatatypeConverter(), false);
        this.addConverter(new DateToStringDatatypeConverter(), false);
        this.addConverter(new StringToDateDatatypeConverter(), false);
        this.addConverter(new CalendarToStringDatatypeConverter(), false);
        this.addConverter(new StringToCalendarDatatypeConverter(), false);
        this.addConverter(new ClassToStringDatatypeConverter(), false);
        this.addConverter(new StringToClassDatatypeConverter(), false);
        this.addConverter(new CalendarToDateDatatypeConverter(), false);
        this.addConverter(new DateToCalendarDatatypeConverter(), false);
        this.addConverter(new URLToStringDatatypeConverter(), false);
        this.addConverter(new StringToURLDatatypeConverter(), false);
        this.addConverter(new LocaleToStringDatatypeConverter(), false);
        this.addConverter(new StringToLocaleDatatypeConverter(), false);
    }

    private void loadAdditionalConverters() {
        ConfigurationReader lReader = new ConfigurationReader();
        List lConverterClasses = lReader.readClassesFromConfigFile("DatatypeConverters", "META-INF/JEAF/XFun", DatatypeConverter.class);
        for (Class lNextClass : lConverterClasses) {
            DatatypeConverter lNewConverter;
            try {
                lNewConverter = (DatatypeConverter)lNextClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new JEAFBootstrapException("Unable to create datatype converter " + lNextClass.getName(), (Throwable)e);
            }
            this.addConverter(lNewConverter, true);
        }
    }
}

