/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters;

import com.anaptecs.jeaf.api.xfun.XFunMessages;
import com.anaptecs.jeaf.xfun.api.datatypeconverter.DatatypeConverter;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import java.math.BigDecimal;

public class BigDecimalToDoubleDatatypeConverter
implements DatatypeConverter<BigDecimal, Double> {
    public static final BigDecimal MAX_DOUBLE = BigDecimal.valueOf(Double.MAX_VALUE);
    public static final BigDecimal MIN_DOUBLE = BigDecimal.valueOf(Double.MIN_VALUE);

    public final Class<BigDecimal> getInputType() {
        return BigDecimal.class;
    }

    public final Class<Double> getOutputType() {
        return Double.class;
    }

    public final Double convert(BigDecimal pInput) {
        Double lOutput;
        if (pInput != null) {
            if (pInput.compareTo(MAX_DOUBLE) > 0 || pInput.compareTo(MIN_DOUBLE) < 0) {
                throw new JEAFSystemException(XFunMessages.DATATYPE_CONVERSION_NOT_POSSIBLE, new String[]{BigDecimal.class.getSimpleName(), Double.class.getSimpleName(), pInput.toString()});
            }
            lOutput = pInput.doubleValue();
        } else {
            lOutput = null;
        }
        return lOutput;
    }
}

