/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters;

import com.anaptecs.jeaf.api.xfun.XFunMessages;
import com.anaptecs.jeaf.xfun.api.datatypeconverter.DatatypeConverter;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import java.math.BigDecimal;

public class BigDecimalToFloatDatatypeConverter
implements DatatypeConverter<BigDecimal, Float> {
    public static final BigDecimal MAX_FLOAT = BigDecimal.valueOf(3.4028234663852886E38);
    public static final BigDecimal MIN_FLOAT = BigDecimal.valueOf(1.4E-45f);

    public final Class<BigDecimal> getInputType() {
        return BigDecimal.class;
    }

    public final Class<Float> getOutputType() {
        return Float.class;
    }

    public final Float convert(BigDecimal pInput) {
        Float lOutput;
        if (pInput != null) {
            if (pInput.compareTo(MAX_FLOAT) > 0) {
                throw new JEAFSystemException(XFunMessages.DATATYPE_CONVERSION_NOT_POSSIBLE, new String[]{BigDecimal.class.getSimpleName(), Float.class.getSimpleName(), pInput.toString()});
            }
            if (pInput.compareTo(MIN_FLOAT) < 0) {
                throw new JEAFSystemException(XFunMessages.DATATYPE_CONVERSION_NOT_POSSIBLE, new String[]{BigDecimal.class.getSimpleName(), Float.class.getSimpleName(), pInput.toString()});
            }
            lOutput = Float.valueOf(pInput.floatValue());
        } else {
            lOutput = null;
        }
        return lOutput;
    }
}

