/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters;

import com.anaptecs.jeaf.api.xfun.XFunMessages;
import com.anaptecs.jeaf.xfun.api.datatypeconverter.DatatypeConverter;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import java.math.BigInteger;

public class BigIntegerToByteDatatypeConverter
implements DatatypeConverter<BigInteger, Byte> {
    public static final BigInteger MAX_BYTE = BigInteger.valueOf(Long.parseLong(Byte.toString((byte)127)));
    public static final BigInteger MIN_BYTE = BigInteger.valueOf(Long.parseLong(Byte.toString((byte)127)));

    public final Class<BigInteger> getInputType() {
        return BigInteger.class;
    }

    public final Class<Byte> getOutputType() {
        return Byte.class;
    }

    public final Byte convert(BigInteger pInput) {
        Byte lOutput;
        if (pInput != null) {
            if (pInput.compareTo(BigInteger.valueOf(127L)) > 0 || pInput.compareTo(BigInteger.valueOf(-128L)) < 0) {
                throw new JEAFSystemException(XFunMessages.DATATYPE_CONVERSION_NOT_POSSIBLE, new String[]{BigInteger.class.getSimpleName(), Byte.class.getSimpleName(), pInput.toString()});
            }
            lOutput = pInput.byteValue();
        } else {
            lOutput = null;
        }
        return lOutput;
    }
}

