/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters;

import com.anaptecs.jeaf.api.xfun.XFunMessages;
import com.anaptecs.jeaf.xfun.api.datatypeconverter.DatatypeConverter;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import java.math.BigInteger;

public class BigIntegerToIntegerDatatypeConverter
implements DatatypeConverter<BigInteger, Integer> {
    public static final BigInteger MAX_INTEGER = BigInteger.valueOf(Integer.MAX_VALUE);
    public static final BigInteger MIN_INTEGER = BigInteger.valueOf(Integer.MIN_VALUE);

    public final Class<BigInteger> getInputType() {
        return BigInteger.class;
    }

    public final Class<Integer> getOutputType() {
        return Integer.class;
    }

    public final Integer convert(BigInteger pInput) {
        Integer lOutput;
        if (pInput != null) {
            if (pInput.compareTo(MAX_INTEGER) > 0 || pInput.compareTo(MIN_INTEGER) < 0) {
                throw new JEAFSystemException(XFunMessages.DATATYPE_CONVERSION_NOT_POSSIBLE, new String[]{BigInteger.class.getSimpleName(), Integer.class.getSimpleName(), pInput.toString()});
            }
            lOutput = pInput.intValue();
        } else {
            lOutput = null;
        }
        return lOutput;
    }
}

