/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters;

import com.anaptecs.jeaf.api.xfun.XFunMessages;
import com.anaptecs.jeaf.xfun.api.datatypeconverter.DatatypeConverter;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import java.math.BigInteger;

public class BigIntegerToLongDatatypeConverter
implements DatatypeConverter<BigInteger, Long> {
    public static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);

    public final Class<BigInteger> getInputType() {
        return BigInteger.class;
    }

    public final Class<Long> getOutputType() {
        return Long.class;
    }

    public final Long convert(BigInteger pInput) {
        Long lOutput;
        if (pInput != null) {
            if (pInput.compareTo(MAX_LONG) > 0 || pInput.compareTo(MIN_LONG) < 0) {
                throw new JEAFSystemException(XFunMessages.DATATYPE_CONVERSION_NOT_POSSIBLE, new String[]{BigInteger.class.getSimpleName(), Long.class.getSimpleName(), pInput.toString()});
            }
            lOutput = pInput.longValue();
        } else {
            lOutput = null;
        }
        return lOutput;
    }
}

