/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters;

import com.anaptecs.jeaf.api.xfun.XFunMessages;
import com.anaptecs.jeaf.xfun.api.datatypeconverter.DatatypeConverter;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import java.math.BigInteger;

public class BigIntegerToShortDatatypeConverter
implements DatatypeConverter<BigInteger, Short> {
    public static final BigInteger MAX_SHORT = BigInteger.valueOf(32767L);
    public static final BigInteger MIN_SHORT = BigInteger.valueOf(-32768L);

    public final Class<BigInteger> getInputType() {
        return BigInteger.class;
    }

    public final Class<Short> getOutputType() {
        return Short.class;
    }

    public final Short convert(BigInteger pInput) {
        Short lOutput;
        if (pInput != null) {
            if (pInput.compareTo(MAX_SHORT) > 0 || pInput.compareTo(MIN_SHORT) < 0) {
                throw new JEAFSystemException(XFunMessages.DATATYPE_CONVERSION_NOT_POSSIBLE, new String[]{BigInteger.class.getSimpleName(), Short.class.getSimpleName(), pInput.toString()});
            }
            lOutput = pInput.shortValue();
        } else {
            lOutput = null;
        }
        return lOutput;
    }
}

