/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters;

import com.anaptecs.jeaf.api.xfun.XFunMessages;
import com.anaptecs.jeaf.xfun.api.datatypeconverter.DatatypeConverter;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;

public class DoubleToFloatDatatypeConverter
implements DatatypeConverter<Double, Float> {
    private static final double MAX_FLOAT = 3.4028234663852886E38;
    private static final double MIN_FLOAT = (double)1.4E-45f;

    public final Class<Double> getInputType() {
        return Double.class;
    }

    public final Class<Float> getOutputType() {
        return Float.class;
    }

    public final Float convert(Double pInput) {
        Float lOutput;
        if (pInput != null) {
            if (pInput > 3.4028234663852886E38 || pInput < (double)1.4E-45f) {
                throw new JEAFSystemException(XFunMessages.DATATYPE_CONVERSION_NOT_POSSIBLE, new String[]{Double.class.getSimpleName(), Float.class.getSimpleName(), pInput.toString()});
            }
            lOutput = Float.valueOf(Float.parseFloat(pInput.toString()));
        } else {
            lOutput = null;
        }
        return lOutput;
    }
}

