/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters;

import com.anaptecs.jeaf.api.xfun.XFunMessages;
import com.anaptecs.jeaf.xfun.api.datatypeconverter.DatatypeConverter;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import java.math.BigInteger;

public class StringToBigIntegerDatatypeConverter
implements DatatypeConverter<String, BigInteger> {
    public static final int MAX_INPUT_LENGTH = 18;
    public static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);

    public final Class<String> getInputType() {
        return String.class;
    }

    public final Class<BigInteger> getOutputType() {
        return BigInteger.class;
    }

    public final BigInteger convert(String pInput) {
        BigInteger lOutput;
        if (pInput != null) {
            if (pInput.length() > 18) {
                throw new JEAFSystemException(XFunMessages.DATATYPE_CONVERSION_NOT_POSSIBLE, new String[]{String.class.getSimpleName(), BigInteger.class.getSimpleName(), pInput});
            }
            lOutput = BigInteger.valueOf(Long.parseLong(pInput));
        } else {
            lOutput = null;
        }
        return lOutput;
    }
}

