/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters;

import com.anaptecs.jeaf.api.xfun.XFunMessages;
import com.anaptecs.jeaf.xfun.api.datatypeconverter.DatatypeConverter;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import java.math.BigDecimal;

public class StringToDoubleDatatypeConverter
implements DatatypeConverter<String, Double> {
    public static final int MAX_INPUT_LENGTH = 324;
    public static final BigDecimal MAX_DOUBLE = BigDecimal.valueOf(Double.MAX_VALUE);
    public static final BigDecimal MIN_DOUBLE = BigDecimal.valueOf(Double.MIN_VALUE);

    public final Class<String> getInputType() {
        return String.class;
    }

    public final Class<Double> getOutputType() {
        return Double.class;
    }

    public final Double convert(String pInput) {
        Double lOutput;
        if (pInput != null) {
            if (pInput.length() > 324) {
                throw new JEAFSystemException(XFunMessages.DATATYPE_CONVERSION_NOT_POSSIBLE, new String[]{String.class.getSimpleName(), Double.class.getSimpleName(), pInput});
            }
            lOutput = Double.parseDouble(pInput);
        } else {
            lOutput = null;
        }
        return lOutput;
    }
}

