/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.xfun.impl.datatypeconverter.converters;

import com.anaptecs.jeaf.api.xfun.XFunMessages;
import com.anaptecs.jeaf.xfun.api.datatypeconverter.DatatypeConverter;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;

public class StringToFloatDatatypeConverter
implements DatatypeConverter<String, Float> {
    public static final int MAX_INPUT_LENGTH = 30;
    public static final Double MAX_FLOAT = 3.4028234663852886E38;
    public static final Double MIN_FLOAT = 1.4E-45f;

    public final Class<String> getInputType() {
        return String.class;
    }

    public final Class<Float> getOutputType() {
        return Float.class;
    }

    public final Float convert(String pInput) {
        Float lOutput;
        if (pInput != null) {
            if (pInput.length() > 30) {
                throw new JEAFSystemException(XFunMessages.DATATYPE_CONVERSION_NOT_POSSIBLE, new String[]{String.class.getSimpleName(), Float.class.getSimpleName(), pInput});
            }
            lOutput = Float.valueOf(Float.parseFloat(pInput));
        } else {
            lOutput = null;
        }
        return lOutput;
    }
}

