/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.xfun.impl.info;

import com.anaptecs.jeaf.xfun.annotations.AppInfo;
import com.anaptecs.jeaf.xfun.api.XFun;
import com.anaptecs.jeaf.xfun.api.config.ConfigurationReader;
import com.anaptecs.jeaf.xfun.api.info.ApplicationInfo;
import com.anaptecs.jeaf.xfun.api.info.ApplicationProvider;
import com.anaptecs.jeaf.xfun.api.info.VersionInfo;
import com.anaptecs.jeaf.xfun.api.trace.TraceLevel;
import com.anaptecs.jeaf.xfun.impl.info.VersionInfoHelper;
import java.net.MalformedURLException;
import java.net.URL;

public class ApplicationInfoLoader {
    public ApplicationInfo readApplicationInfoFromConfiguredClass(String pConfigurationFileName, String pBasePackagePath) {
        ApplicationInfo lApplicationInfo;
        try {
            ConfigurationReader lReader = new ConfigurationReader();
            Class lAppInfoClass = lReader.readClassFromConfigFile(pConfigurationFileName, pBasePackagePath);
            ApplicationInfoLoader lLoader = new ApplicationInfoLoader();
            lApplicationInfo = lLoader.loadApplicationInfo(lAppInfoClass);
        }
        catch (RuntimeException e) {
            lApplicationInfo = ApplicationInfo.UNKNOWN_APPLICATION;
            XFun.getTrace().writeEmergencyTrace("Runtime exception when trying to load application info.", (Throwable)e, TraceLevel.WARN);
        }
        return lApplicationInfo;
    }

    public ApplicationInfo loadApplicationInfo(Class<?> pAppInfoClass) {
        ApplicationInfo lApplicationInfo;
        if (pAppInfoClass != null) {
            AppInfo lAnnotation = pAppInfoClass.getAnnotation(AppInfo.class);
            if (lAnnotation != null) {
                String lCreator = lAnnotation.applicationCreator();
                URL lCreatorURL = this.toURL(lAnnotation.applicationCreatorURL());
                String lURLString = lCreatorURL != null ? lCreatorURL.toExternalForm() : null;
                ApplicationProvider lApplicationProvider = new ApplicationProvider(lCreator, lURLString);
                String lApplicationID = lAnnotation.applicationID();
                String lApplicationName = lAnnotation.applicationName();
                URL lApplicationWebsiteURL = this.toURL(lAnnotation.applicationWebsiteURL());
                lURLString = lApplicationWebsiteURL != null ? lApplicationWebsiteURL.toExternalForm() : null;
                String lDescription = lAnnotation.applicationDescription();
                VersionInfo lVersionInfo = VersionInfoHelper.loadVersionInfo(lAnnotation.versionInfoPropertyFileName());
                lApplicationInfo = new ApplicationInfo(lApplicationID, lApplicationName, lURLString, lDescription, lApplicationProvider, lVersionInfo);
            } else {
                lApplicationInfo = ApplicationInfo.UNKNOWN_APPLICATION;
                XFun.getTrace().writeInitInfo("Configured class " + pAppInfoClass.getName() + " does not have required annotation @AppInfo. Using fallback to generic application info.", TraceLevel.WARN);
            }
        } else {
            lApplicationInfo = ApplicationInfo.UNKNOWN_APPLICATION;
            XFun.getTrace().writeInitInfo("Application info is not available. Please make use of annotation @AppInfo. Using fallback to generic application info.", TraceLevel.WARN);
        }
        return lApplicationInfo;
    }

    private URL toURL(String pURLString) {
        try {
            return new URL(pURLString);
        }
        catch (MalformedURLException e) {
            URL lURL = null;
            return lURL;
        }
    }
}

