/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.xfun.impl.info;

import com.anaptecs.jeaf.xfun.api.XFun;
import com.anaptecs.jeaf.xfun.api.config.Configuration;
import com.anaptecs.jeaf.xfun.api.info.VersionInfo;
import java.util.Date;

public final class VersionInfoHelper {
    public static final String VERSION = "VERSION";
    public static final String CREATION_DATE = "CREATION_DATE";

    private VersionInfoHelper() {
    }

    public static VersionInfo loadVersionInfo(String pVersionBundleName) {
        VersionInfo lVersionInfo;
        if (pVersionBundleName != null) {
            Configuration lConfiguration = null;
            try {
                lConfiguration = XFun.getConfigurationProvider().getResourceConfiguration(pVersionBundleName);
                Date lCreationDate = (Date)lConfiguration.getConfigurationValue(CREATION_DATE, true, Date.class);
                String lMavenVersionString = (String)lConfiguration.getConfigurationValue(VERSION, null, String.class);
                lVersionInfo = new VersionInfo(lMavenVersionString, lCreationDate);
            }
            catch (RuntimeException e) {
                String lMessage = "Unable to load version info from resource bundle '" + pVersionBundleName + "'. Resource was not found in classpath. Please correct your configuration. Using generic version info '" + VersionInfo.UNKNOWN_VERSION.toString() + "' as fallback.";
                XFun.getTrace().writeEmergencyTrace(lMessage, (Throwable)e);
                lVersionInfo = VersionInfo.UNKNOWN_VERSION;
            }
        } else {
            lVersionInfo = VersionInfo.UNKNOWN_VERSION;
        }
        return lVersionInfo;
    }
}

