/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.xfun.impl.messages;

import com.anaptecs.jeaf.tools.api.Tools;
import com.anaptecs.jeaf.xfun.api.XFun;
import com.anaptecs.jeaf.xfun.api.checks.Assert;
import com.anaptecs.jeaf.xfun.api.checks.Check;
import com.anaptecs.jeaf.xfun.api.errorhandling.ErrorCode;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import com.anaptecs.jeaf.xfun.api.errorhandling.SystemException;
import com.anaptecs.jeaf.xfun.api.messages.LocalizedObject;
import com.anaptecs.jeaf.xfun.api.messages.LocalizedString;
import com.anaptecs.jeaf.xfun.api.messages.MessageDataDTD;
import com.anaptecs.jeaf.xfun.api.messages.MessageDefinition;
import com.anaptecs.jeaf.xfun.api.messages.MessageID;
import com.anaptecs.jeaf.xfun.api.messages.MessageRepository;
import com.anaptecs.jeaf.xfun.api.trace.Trace;
import com.anaptecs.jeaf.xfun.api.trace.TraceConfiguration;
import com.anaptecs.jeaf.xfun.api.trace.TraceLevel;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class MessageRepositoryImpl
implements MessageRepository {
    private static final long serialVersionUID = 1L;
    private static final String LINE_SEPERATOR = System.getProperty("line.separator");
    public static final ErrorCode RESOURCE_ALREADY_LOADED;
    public static final ErrorCode LOCALIZATION_ID_ALREADY_IN_USE;
    public static final ErrorCode UNABLE_TO_PARSE_XML_FILE;
    public static final ErrorCode MESSAGE_ID_ALREADY_USED_TO_IDENTIFY_MESSAGE;
    public static final ErrorCode VERSION_DETAIL_NOT_DEFINED;
    public static final ErrorCode INVALID_VERSION_NUMBER_FORMAT;
    public static final ErrorCode INVALID_CREATION_DATE_FORMAT;
    public static final ErrorCode INVALID_MESSAGE_FORMAT;
    public static final ErrorCode UNKNOWN_MESSAGE_CODE;
    private static final String MESSAGE_RESOURCE = "BasicMessages.xml";
    private final Map<Integer, LocalizedObject> localizationIDs;
    private final Map<LocalizedObject, MessageFormat> defaultMessages;
    private final Map<Locale, Map<LocalizedObject, MessageFormat>> localizedMessageMaps;
    private final Set<String> loadedResources;
    private final Set<Integer> usedLocalizationIDs = new HashSet<Integer>();
    private final String traceMessageFormat;
    private boolean showCurrentUserInTraces;
    private Locale traceLocale;
    private static final MessageRepositoryImpl INSTANCE;

    public MessageRepositoryImpl(Collection<Element> pInitialMessageElements) {
        Assert.assertNotNull(pInitialMessageElements, (String)"pInitialMessageElements");
        this.localizationIDs = new HashMap<Integer, LocalizedObject>();
        this.defaultMessages = new HashMap<LocalizedObject, MessageFormat>();
        this.localizedMessageMaps = new HashMap<Locale, Map<LocalizedObject, MessageFormat>>();
        this.loadedResources = new HashSet<String>();
        TraceConfiguration lTraceConfiguration = TraceConfiguration.getInstance();
        this.traceMessageFormat = lTraceConfiguration.getTraceMessageFormat();
        this.showCurrentUserInTraces = lTraceConfiguration.showCurrentUserInTraces();
        this.traceLocale = this.resolveTraceLocale();
        this.addMessageElements(pInitialMessageElements);
    }

    public static MessageRepositoryImpl getInstance() {
        return INSTANCE;
    }

    public void loadResource(String pMessageResource) throws SystemException {
        Check.checkInvalidParameterNull((Object)pMessageResource, (String)"pMessageResource");
        Trace lTrace = XFun.getTrace();
        lTrace.info("Loading message resource " + pMessageResource);
        if (!this.loadedResources.contains(pMessageResource)) {
            try {
                Collection<Element> lReadMessageElements = MessageRepositoryImpl.internalLoadResource(pMessageResource);
                this.addMessageElements(lReadMessageElements);
                this.loadedResources.add(pMessageResource);
            }
            catch (IOException e) {
                String[] lParams = new String[]{pMessageResource};
                lTrace.error((MessageID)UNABLE_TO_PARSE_XML_FILE, (Throwable)e, lParams);
                throw new JEAFSystemException(UNABLE_TO_PARSE_XML_FILE, lParams, (Throwable)e);
            }
        }
    }

    private void loadResourcesFromClasspath() {
        XFun.getConfiguration().getMessageResourceClasses();
    }

    private static Collection<Element> internalLoadResource(String pMessageResource) throws IOException {
        ClassLoader lClassLoader = MessageRepositoryImpl.class.getClassLoader();
        InputStream lResourceStream = lClassLoader.getResourceAsStream(pMessageResource);
        if (lResourceStream != null) {
            Document lDocument = Tools.getXMLTools().parseInputStream(lResourceStream, true, MessageDataDTD.SYSTEM_ID, pMessageResource);
            NodeList lMessageNodeList = lDocument.getElementsByTagName("Message");
            Assert.assertNotNull((Object)lMessageNodeList, (String)"lMessageNodeList");
            ArrayList<Element> lMessageElements = new ArrayList<Element>(lMessageNodeList.getLength());
            for (int i = 0; i < lMessageNodeList.getLength(); ++i) {
                Element lElement = (Element)lMessageNodeList.item(i);
                lMessageElements.add(lElement);
            }
            return lMessageElements;
        }
        String lMessage = "Resource '" + pMessageResource + "' could not be found within the application class path.";
        throw new IOException(lMessage);
    }

    private void addMessageElements(Collection<Element> pMessageElements) {
        for (Element lMessageElement : pMessageElements) {
            LocalizedObject lLocalizedObject = this.createLocalizedObject(lMessageElement);
            this.localizationIDs.put(lLocalizedObject.getLocalizationID(), lLocalizedObject);
        }
    }

    private void addDefaultMessage(LocalizedObject pLocalizedObject, MessageFormat pMessageFormat) throws SystemException {
        Assert.assertNotNull((Object)pLocalizedObject, (String)"pMessageID");
        Assert.assertNotNull((Object)pMessageFormat, (String)"pMessageFormat");
        if (this.defaultMessages.containsKey(pLocalizedObject)) {
            String[] lParams = new String[]{Integer.toString(pLocalizedObject.getLocalizationID())};
            throw new JEAFSystemException(MESSAGE_ID_ALREADY_USED_TO_IDENTIFY_MESSAGE, lParams);
        }
        this.defaultMessages.put(pLocalizedObject, pMessageFormat);
    }

    private void addLocalizedMessage(LocalizedObject pLocalizedObject, MessageFormat pMessageFormat, Locale pLocale) throws SystemException {
        Assert.assertNotNull((Object)pLocalizedObject, (String)"pMessageID");
        Assert.assertNotNull((Object)pMessageFormat, (String)"pMessageFormat");
        Assert.assertNotNull((Object)pLocale, (String)"pLocale");
        Map lLocalizedMap = this.localizedMessageMaps.computeIfAbsent(pLocale, f -> new HashMap());
        if (lLocalizedMap.containsKey(pLocalizedObject)) {
            String[] lParams = new String[]{Integer.toString(pLocalizedObject.getLocalizationID())};
            throw new JEAFSystemException(MESSAGE_ID_ALREADY_USED_TO_IDENTIFY_MESSAGE, lParams);
        }
        lLocalizedMap.put(pLocalizedObject, pMessageFormat);
    }

    private TraceLevel getTraceLevel(String pTraceLevel) {
        TraceLevel lTraceLevel = pTraceLevel != null && pTraceLevel.trim().length() > 0 ? TraceLevel.valueOf((String)pTraceLevel) : TraceLevel.ERROR;
        return lTraceLevel;
    }

    public LocalizedObject getLocalizedObject(int pLocalizationID) throws SystemException {
        LocalizedObject lLocalizedObject = this.localizationIDs.get(pLocalizationID);
        if (lLocalizedObject != null) {
            return lLocalizedObject;
        }
        throw new JEAFSystemException(UNKNOWN_MESSAGE_CODE, new String[]{Integer.toString(pLocalizationID)});
    }

    public MessageID getMessageID(int pMessageCode) throws SystemException {
        return (MessageID)this.getLocalizedObject(pMessageCode);
    }

    public boolean existsMessage(int pMessageCode) {
        return this.localizationIDs.containsKey(pMessageCode);
    }

    public ErrorCode getErrorCode(int pErrorCode) throws SystemException {
        return (ErrorCode)this.getLocalizedObject(pErrorCode);
    }

    public LocalizedString getLocalizedString(int pLocalizationID) throws SystemException {
        return (LocalizedString)this.getLocalizedObject(pLocalizationID);
    }

    private LocalizedObject createLocalizedObject(Element pMessageElement) throws SystemException {
        String lMessageCodeString = pMessageElement.getAttribute("messageID");
        Integer lLocalizationID = Integer.valueOf(lMessageCodeString);
        if (!this.isLocalizationIDUsed(lLocalizationID)) {
            MessageFormat lMessageFormat;
            String lMessagePattern = null;
            try {
                lMessagePattern = pMessageElement.getAttribute("defaultText");
                lMessagePattern = lMessagePattern.replace("\\\\n", LINE_SEPERATOR);
                lMessageFormat = new MessageFormat(lMessagePattern);
            }
            catch (IllegalArgumentException e) {
                throw new JEAFSystemException(INVALID_MESSAGE_FORMAT, new String[]{lLocalizationID.toString(), lMessagePattern}, (Throwable)e);
            }
            String lTraceLevelString = pMessageElement.getAttribute("traceLevel");
            TraceLevel lTraceLevel = this.getTraceLevel(lTraceLevelString);
            String lType = pMessageElement.getAttribute("type");
            Object lLocalizedObject = "INFO".equals(lType) ? new MessageID(lLocalizationID.intValue(), lTraceLevel) : ("ERROR".equals(lType) ? new ErrorCode(lLocalizationID.intValue(), lTraceLevel) : new LocalizedString(lLocalizationID.intValue()));
            this.addDefaultMessage((LocalizedObject)lLocalizedObject, lMessageFormat);
            NodeList lLocalizedMessageElements = pMessageElement.getElementsByTagName("LocalizedMessage");
            for (int i = 0; i < lLocalizedMessageElements.getLength(); ++i) {
                MessageFormat lNextMessageFormat;
                Element lNextLocalizedMessageElement = (Element)lLocalizedMessageElements.item(i);
                String lNextLanguage = lNextLocalizedMessageElement.getAttribute("language");
                String lNextCountry = lNextLocalizedMessageElement.getAttribute("country");
                String lNextVariant = lNextLocalizedMessageElement.getAttribute("variant");
                Locale lNextLocale = new Locale(lNextLanguage, lNextCountry, lNextVariant);
                String lNextMessagePattern = lNextLocalizedMessageElement.getAttribute("localizedText");
                lNextMessagePattern = lNextMessagePattern.replace("\\n", LINE_SEPERATOR);
                try {
                    lNextMessageFormat = new MessageFormat(lNextMessagePattern);
                }
                catch (IllegalArgumentException e) {
                    throw new JEAFSystemException(INVALID_MESSAGE_FORMAT, new String[]{lLocalizationID.toString(), lMessagePattern}, (Throwable)e);
                }
                this.addLocalizedMessage((LocalizedObject)lLocalizedObject, lNextMessageFormat, lNextLocale);
            }
            this.usedLocalizationIDs.add(lLocalizationID);
            return lLocalizedObject;
        }
        XFun.getTrace().write((MessageID)LOCALIZATION_ID_ALREADY_IN_USE, new String[]{lLocalizationID.toString()});
        throw new JEAFSystemException(LOCALIZATION_ID_ALREADY_IN_USE, new String[]{lLocalizationID.toString()});
    }

    public String getMessage(LocalizedObject pLocalizedObject, String ... pMessageParameters) {
        return this.getMessage(pLocalizedObject, XFun.getLocaleProvider().getCurrentLocale(), pMessageParameters);
    }

    public String getTraceMessage(LocalizedObject pLocalizedObject, String ... pMessageParameters) {
        Principal lCurrentPrincipal;
        String lMessage = this.getMessage(pLocalizedObject, this.traceLocale, pMessageParameters);
        String lCurrentUser = this.showCurrentUserInTraces ? ((lCurrentPrincipal = XFun.getPrincipalProvider().getCurrentPrincipal()) != null ? lCurrentPrincipal.getName() : " ") : " ";
        return String.format(this.traceMessageFormat, pLocalizedObject.getLocalizationID(), lMessage, lCurrentUser);
    }

    public String getMessage(LocalizedObject pLocalizedObject, Locale pLocale, String ... pMessageParameters) {
        String lMessage;
        Check.checkInvalidParameterNull((Object)pLocalizedObject, (String)"pLocalizedObject");
        Check.checkInvalidParameterNull((Object)pLocale, (String)"pLocale");
        MessageFormat lMessageFormat = this.getMessageFormat(pLocalizedObject, pLocale);
        if (lMessageFormat != null) {
            lMessage = lMessageFormat.format(pMessageParameters);
        } else {
            lMessage = "[ID-" + pLocalizedObject.getLocalizationID() + "] Unable to return real message. ID is unknown";
            RuntimeException lRuntimeException = new RuntimeException(lMessage);
            XFun.getTrace().error(lMessage, (Throwable)lRuntimeException);
        }
        return lMessage;
    }

    private MessageFormat getMessageFormat(LocalizedObject pLocalizedObject, Locale pLocale) {
        MessageFormat lMessageFormat = null;
        Map<LocalizedObject, MessageFormat> lMessageMap = this.localizedMessageMaps.get(pLocale);
        if (lMessageMap != null) {
            lMessageFormat = lMessageMap.get(pLocalizedObject);
        }
        if (lMessageFormat == null) {
            Locale lReducedLocale = this.reduceLocale(pLocale);
            lMessageFormat = lReducedLocale != null ? this.getMessageFormat(pLocalizedObject, lReducedLocale) : this.defaultMessages.get(pLocalizedObject);
        }
        return lMessageFormat;
    }

    private Locale reduceLocale(Locale pLocale) {
        Assert.assertNotNull((Object)pLocale, (String)"pLocale");
        Locale lReducedLocale = pLocale.getVariant().length() > 0 ? new Locale(pLocale.getLanguage(), pLocale.getCountry()) : (pLocale.getCountry().length() > 0 ? new Locale(pLocale.getLanguage()) : null);
        return lReducedLocale;
    }

    public void addAllMessages(List<MessageDefinition> pMessages) {
        Check.checkInvalidParameterNull(pMessages, (String)"pMessages");
        for (MessageDefinition lNextMessage : pMessages) {
            LocalizedObject lLocalizedObject = lNextMessage.getLocalizedObject();
            this.localizationIDs.put(lLocalizedObject.getLocalizationID(), lLocalizedObject);
            this.defaultMessages.put(lLocalizedObject, lNextMessage.getDefaultMessage());
            Set lEntrySet = lNextMessage.getLocalizedMessages().entrySet();
            for (Map.Entry lNextEntry : lEntrySet) {
                Locale lLocale = (Locale)lNextEntry.getKey();
                Map<LocalizedObject, MessageFormat> lExistingMap = this.localizedMessageMaps.get(lLocale);
                if (lExistingMap != null) {
                    lExistingMap.put(lLocalizedObject, (MessageFormat)lNextEntry.getValue());
                    continue;
                }
                HashMap lNewMap = new HashMap();
                lNewMap.put(lLocalizedObject, lNextEntry.getValue());
                this.localizedMessageMaps.put(lLocale, lNewMap);
            }
        }
    }

    public List<MessageDefinition> getAllMessages() {
        ArrayList<MessageDefinition> lAllMessage = new ArrayList<MessageDefinition>(this.defaultMessages.size());
        for (Map.Entry<LocalizedObject, MessageFormat> lNextEntry : this.defaultMessages.entrySet()) {
            LocalizedObject lKey = lNextEntry.getKey();
            MessageFormat lDefaultMessage = lNextEntry.getValue();
            HashMap<Locale, MessageFormat> lLocalizations = new HashMap<Locale, MessageFormat>();
            for (Map.Entry<Locale, Map<LocalizedObject, MessageFormat>> lEntry : this.localizedMessageMaps.entrySet()) {
                Locale lLocale = lEntry.getKey();
                Map<LocalizedObject, MessageFormat> lValues = lEntry.getValue();
                MessageFormat lMessageFormat = lValues.get(lKey);
                if (lMessageFormat == null) continue;
                lLocalizations.put(lLocale, lMessageFormat);
            }
            MessageDefinition lMessage = new MessageDefinition(lKey, lDefaultMessage, lLocalizations);
            lAllMessage.add(lMessage);
        }
        return lAllMessage;
    }

    public Locale getTraceLocale() {
        return this.traceLocale;
    }

    public void setTraceLocale(Locale pLocale) {
        Check.checkInvalidParameterNull((Object)pLocale, (String)"pLocale");
        this.traceLocale = pLocale;
    }

    public boolean showCurrentUserInTraces() {
        return this.showCurrentUserInTraces;
    }

    public void setShowCurrentUserInTraces(boolean pShowCurrentUser) {
        this.showCurrentUserInTraces = pShowCurrentUser;
    }

    private Locale resolveTraceLocale() {
        TraceConfiguration lTraceConfiguration = TraceConfiguration.getInstance();
        Locale lTraceLocale = lTraceConfiguration.isTraceWithSystemLocaleEnabled() ? Locale.getDefault(Locale.Category.DISPLAY) : lTraceConfiguration.getCustomTraceLocale();
        return lTraceLocale;
    }

    private synchronized boolean isLocalizationIDUsed(Integer pLocalizationID) {
        return this.usedLocalizationIDs.contains(pLocalizationID);
    }

    static {
        try {
            MessageRepositoryImpl lMessageRepository;
            Collection<Element> lMessageElements = MessageRepositoryImpl.internalLoadResource(MESSAGE_RESOURCE);
            INSTANCE = lMessageRepository = new MessageRepositoryImpl(lMessageElements);
            RESOURCE_ALREADY_LOADED = lMessageRepository.getErrorCode(5);
            LOCALIZATION_ID_ALREADY_IN_USE = lMessageRepository.getErrorCode(6);
            UNABLE_TO_PARSE_XML_FILE = lMessageRepository.getErrorCode(7);
            MESSAGE_ID_ALREADY_USED_TO_IDENTIFY_MESSAGE = lMessageRepository.getErrorCode(8);
            UNKNOWN_MESSAGE_CODE = lMessageRepository.getErrorCode(9);
            VERSION_DETAIL_NOT_DEFINED = lMessageRepository.getErrorCode(10);
            INVALID_VERSION_NUMBER_FORMAT = lMessageRepository.getErrorCode(11);
            INVALID_CREATION_DATE_FORMAT = lMessageRepository.getErrorCode(12);
            INVALID_MESSAGE_FORMAT = lMessageRepository.getErrorCode(13);
            lMessageRepository.loadResourcesFromClasspath();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }
}

