/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.xfun.impl.trace;

import com.anaptecs.jeaf.xfun.api.trace.AbstractTraceImpl;
import com.anaptecs.jeaf.xfun.api.trace.TraceLevel;
import com.anaptecs.jeaf.xfun.bootstrap.Assert;
import com.anaptecs.jeaf.xfun.bootstrap.Check;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.helpers.Loader;

abstract class AbstractCommonsLoggingTraceImpl
extends AbstractTraceImpl {
    private final Log logger;
    private static boolean log4JConfigChecked;

    AbstractCommonsLoggingTraceImpl(String pLoggerName) {
        Check.checkInvalidParameterNull((Object)pLoggerName, (String)"pLoggerName");
        AbstractCommonsLoggingTraceImpl.checkAndFixLog4JConfiguration();
        this.logger = LogFactory.getLog((String)pLoggerName);
    }

    static void checkAndFixLog4JConfiguration() {
        if (!log4JConfigChecked) {
            URL lResource;
            String lProperty = System.getProperty("log4j.configuration");
            if (lProperty == null && (lResource = Loader.getResource((String)"log4j.xml")) == null && (lResource = Loader.getResource((String)"log4j.properties")) == null) {
                System.setProperty("log4j.configuration", "jeaf-log4j-fallback-configuration.xml");
                Log lLogger = LogFactory.getLog((String)"DEFAULT_TRACE");
                lLogger.info((Object)"Using JEAF fallback Log4J configuration as no Log4J configuration is available.");
            }
            log4JConfigChecked = true;
        }
    }

    protected void log(TraceLevel pTraceLevel, String pMessage, Throwable pThrowable) {
        if (pTraceLevel == null) {
            pTraceLevel = TraceLevel.ERROR;
        }
        switch (pTraceLevel) {
            case TRACE: {
                this.logger.trace((Object)pMessage, pThrowable);
                break;
            }
            case DEBUG: {
                this.logger.debug((Object)pMessage, pThrowable);
                break;
            }
            case INFO: {
                this.logger.info((Object)pMessage, pThrowable);
                break;
            }
            case WARN: {
                this.logger.warn((Object)pMessage, pThrowable);
                break;
            }
            case ERROR: {
                this.logger.error((Object)pMessage, pThrowable);
                break;
            }
            case FATAL: {
                this.logger.fatal((Object)pMessage, pThrowable);
                break;
            }
            default: {
                this.logger.fatal((Object)pMessage, pThrowable);
            }
        }
    }

    public void writeEmergencyTrace(String pMessage, Throwable pThrowable, TraceLevel pTraceLevel) {
        Log lLogger = LogFactory.getLog((String)"JEAF_EMERGENCY");
        if (pTraceLevel == null) {
            pTraceLevel = TraceLevel.FATAL;
        }
        switch (pTraceLevel) {
            case TRACE: {
                lLogger.trace((Object)pMessage, pThrowable);
                break;
            }
            case DEBUG: {
                lLogger.debug((Object)pMessage, pThrowable);
                break;
            }
            case INFO: {
                lLogger.info((Object)pMessage, pThrowable);
                break;
            }
            case WARN: {
                lLogger.warn((Object)pMessage, pThrowable);
                break;
            }
            case ERROR: {
                lLogger.error((Object)pMessage, pThrowable);
                break;
            }
            case FATAL: {
                lLogger.fatal((Object)pMessage, pThrowable);
                break;
            }
            default: {
                lLogger.fatal((Object)pMessage, pThrowable);
            }
        }
    }

    public boolean isLevelEnabled(TraceLevel pTraceLevel) {
        Check.checkInvalidParameterNull((Object)pTraceLevel, (String)"pTraceLevel");
        boolean lTraceEnabled = false;
        switch (pTraceLevel) {
            case TRACE: {
                lTraceEnabled = this.logger.isTraceEnabled();
                break;
            }
            case DEBUG: {
                lTraceEnabled = this.logger.isDebugEnabled();
                break;
            }
            case INFO: {
                lTraceEnabled = this.logger.isInfoEnabled();
                break;
            }
            case WARN: {
                lTraceEnabled = this.logger.isWarnEnabled();
                break;
            }
            case ERROR: {
                lTraceEnabled = this.logger.isErrorEnabled();
                break;
            }
            case FATAL: {
                lTraceEnabled = this.logger.isFatalEnabled();
                break;
            }
            default: {
                Assert.unexpectedEnumLiteral((Enum)pTraceLevel);
            }
        }
        return lTraceEnabled;
    }

    static {
        AbstractCommonsLoggingTraceImpl.checkAndFixLog4JConfiguration();
        log4JConfigChecked = false;
    }
}

