/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.xfun.impl.trace;

import com.anaptecs.jeaf.xfun.api.XFun;
import com.anaptecs.jeaf.xfun.api.checks.Check;
import com.anaptecs.jeaf.xfun.api.messages.LocalizedObject;
import com.anaptecs.jeaf.xfun.api.messages.MessageID;
import com.anaptecs.jeaf.xfun.api.messages.MessageRepository;
import com.anaptecs.jeaf.xfun.api.trace.ContextStackElement;
import com.anaptecs.jeaf.xfun.api.trace.TraceConfiguration;
import com.anaptecs.jeaf.xfun.impl.trace.AbstractCommonsLoggingTraceImpl;
import java.util.Stack;

public class TraceImpl
extends AbstractCommonsLoggingTraceImpl {
    private static final String EMPTY_STRING = "";
    private static ThreadLocal<Stack<ContextStackElement>> contextStackHolder = new ThreadLocal();
    private boolean indentTrace;
    private String indentSize;

    private static Stack<ContextStackElement> getContextStack() {
        Stack<Object> lContextStack = contextStackHolder.get();
        if (lContextStack == null) {
            lContextStack = new Stack();
            contextStackHolder.set(lContextStack);
        }
        return lContextStack;
    }

    static ContextStackElement getCurrentContextStackElement() {
        Stack<ContextStackElement> lContextStack = TraceImpl.getContextStack();
        ContextStackElement lElement = !lContextStack.isEmpty() ? lContextStack.peek() : null;
        return lElement;
    }

    public TraceImpl(String pLoggerName) {
        this(pLoggerName, TraceConfiguration.getInstance());
    }

    public TraceImpl(String pLoggerName, TraceConfiguration pTraceConfiguration) {
        super(pLoggerName);
        this.configureIndentation(pTraceConfiguration);
    }

    protected String getMessage(MessageID pMessageID, String[] pMessageParameters) {
        String lMessage;
        if (pMessageID != null) {
            MessageRepository lMessageRepository = XFun.getMessageRepository();
            lMessage = this.getCurrentIndentation() + lMessageRepository.getTraceMessage((LocalizedObject)pMessageID, pMessageParameters);
        } else {
            lMessage = null;
        }
        return lMessage;
    }

    private void configureIndentation(TraceConfiguration pTraceConfig) {
        if (pTraceConfig != null) {
            this.indentTrace = pTraceConfig.isTraceIndentationEnabled();
            int lIndentSize = pTraceConfig.getIndentSize();
            StringBuilder lIndentBuffer = new StringBuilder(lIndentSize);
            for (int i = 0; i < lIndentSize; ++i) {
                lIndentBuffer.append(' ');
            }
            this.indentSize = lIndentBuffer.toString();
        }
    }

    private String getCurrentIndentation() {
        String lCurrentIndentation;
        if (this.indentTrace) {
            int lCurrentLevel = this.getIndentationLevel();
            StringBuilder lIndent = new StringBuilder(lCurrentLevel * this.indentSize.length());
            for (int i = 0; i < lCurrentLevel; ++i) {
                lIndent.append(this.indentSize);
            }
            lCurrentIndentation = lIndent.toString();
        } else {
            lCurrentIndentation = EMPTY_STRING;
        }
        return lCurrentIndentation;
    }

    private Integer getIndentationLevel() {
        return TraceImpl.getContextStack().size();
    }

    public void newContextStack(ContextStackElement pContextStackElement) {
        Check.checkInvalidParameterNull((Object)pContextStackElement, (String)"pContextStackElement");
        Stack<ContextStackElement> lContextStack = TraceImpl.getContextStack();
        lContextStack.clear();
        lContextStack.push(pContextStackElement);
    }

    public void pushContextStackElement(ContextStackElement pContextStackElement) {
        Check.checkInvalidParameterNull((Object)pContextStackElement, (String)"pContextStackElement");
        Stack<ContextStackElement> lContextStack = TraceImpl.getContextStack();
        lContextStack.push(pContextStackElement);
    }

    public ContextStackElement popContextStackElement() {
        Stack<ContextStackElement> lContextStack = TraceImpl.getContextStack();
        ContextStackElement lElement = !lContextStack.isEmpty() ? lContextStack.pop() : null;
        return lElement;
    }
}

