/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.xfun.impl.trace;

import com.anaptecs.jeaf.xfun.api.XFun;
import com.anaptecs.jeaf.xfun.api.checks.Check;
import com.anaptecs.jeaf.xfun.api.common.ComponentID;
import com.anaptecs.jeaf.xfun.api.trace.ContextStackElement;
import com.anaptecs.jeaf.xfun.api.trace.Trace;
import com.anaptecs.jeaf.xfun.api.trace.TraceProvider;
import com.anaptecs.jeaf.xfun.impl.trace.TraceImpl;
import java.util.HashMap;
import java.util.Map;

public class TraceProviderImpl
implements TraceProvider {
    private final Map<String, Trace> traces = new HashMap<String, Trace>();
    private final Map<ComponentID, Trace> tracesByComponent = new HashMap<ComponentID, Trace>();
    public final Trace defaultTrace;

    public TraceProviderImpl() {
        String lApplicationID = XFun.getInfoProvider().getApplicationInfo().getApplicationID();
        this.defaultTrace = new TraceImpl(lApplicationID);
    }

    public Trace getTrace(String pLoggerName) {
        Check.checkInvalidParameterNull((Object)pLoggerName, (String)"pLoggerName");
        return this.traces.computeIfAbsent(pLoggerName, f -> new TraceImpl(pLoggerName));
    }

    public Trace getTrace(Class<?> pClass) {
        Check.checkInvalidParameterNull(pClass, (String)"pClass");
        String lPackageName = pClass.getPackage().getName();
        return this.getTrace(lPackageName);
    }

    public Trace getTrace(ComponentID pComponentID) {
        Check.checkInvalidParameterNull((Object)pComponentID, (String)"pComponentID");
        Trace lTrace = this.tracesByComponent.get(pComponentID);
        if (lTrace == null) {
            String lLoggerName = this.getLoggerName(pComponentID);
            lTrace = this.getTrace(lLoggerName);
            this.tracesByComponent.put(pComponentID, lTrace);
        }
        return lTrace;
    }

    public Trace getCurrentTrace() {
        Trace lTrace;
        ContextStackElement lCurrentContextStackElement = TraceImpl.getCurrentContextStackElement();
        if (lCurrentContextStackElement != null) {
            ComponentID lComponentID = lCurrentContextStackElement.getComponentID();
            lTrace = this.getTrace(lComponentID);
        } else {
            lTrace = this.defaultTrace;
        }
        return lTrace;
    }

    private String getLoggerName(ComponentID pComponentID) {
        String lApplicationID = XFun.getInfoProvider().getApplicationInfo().getApplicationID();
        StringBuilder lBuffer = new StringBuilder();
        lBuffer.append(lApplicationID);
        lBuffer.append(".");
        lBuffer.append(pComponentID.getComponentName());
        return lBuffer.toString();
    }
}

