/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.trap.offline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.twdata.maven.trap.EnvMavenInterceptor;

public class MavenAlwaysOfflineInterceptor
extends EnvMavenInterceptor {
    private static final Set<String> ONLINE_ARGS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("\"release:perform\"", "\"deploy\"", "\"dependency:resolve\"", "\"-U\"")));
    private static final String OFFLINE = "\"-o\"";

    public String[] onBefore(String[] args) {
        ArrayList<String> argsList = new ArrayList<String>(Arrays.asList(args));
        if (argsList.contains(OFFLINE) || !Collections.disjoint(ONLINE_ARGS, argsList)) {
            argsList.remove(OFFLINE);
        } else {
            argsList.add(OFFLINE);
        }
        return argsList.toArray(new String[argsList.size()]);
    }

    public void onAfter(int exitCode) {
    }

    protected String getEnvironmentVariableName() {
        return "MAVEN_ALWAYS_OFFLINE";
    }
}

