/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.yamlpom;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.io.IOUtils;
import org.twdata.maven.yamlpom.MD5;
import org.twdata.maven.yamlpom.SyncFile;
import org.yaml.snakeyaml.Loader;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;

public class SyncManager {
    private final File xmlFile;
    private final File yamlFile;
    private final File syncFile;
    private final SyncFile sync;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncManager(File xmlFile, File yamlFile, File syncFile) {
        SyncFile tmpSync;
        this.xmlFile = xmlFile;
        this.yamlFile = yamlFile;
        this.syncFile = syncFile;
        Loader loader = new Loader(new Constructor(SyncFile.class));
        Yaml yaml = new Yaml(loader);
        FileReader reader = null;
        try {
            reader = new FileReader(syncFile);
            tmpSync = (SyncFile)yaml.load(reader);
        }
        catch (FileNotFoundException e) {
            try {
                tmpSync = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
            IOUtils.closeQuietly(reader);
        }
        IOUtils.closeQuietly(reader);
        this.sync = tmpSync;
    }

    public FormatToTarget determineFormatToTarget() {
        if (!this.yamlFile.exists() && this.xmlFile.exists()) {
            return FormatToTarget.YAML;
        }
        if (this.yamlFile.exists() && !this.xmlFile.exists()) {
            return FormatToTarget.XML;
        }
        if (this.sync != null) {
            if (this.xmlHasSameTimestamp() && this.yamlHasSameTimestamp()) {
                return FormatToTarget.NONE;
            }
            MD5 md5 = new MD5();
            String xmlMd5 = md5.hashFile(this.xmlFile);
            String yamlMd5 = md5.hashFile(this.yamlFile);
            if (this.xmlHasSameHash(xmlMd5) && this.yamlHasSameHash(yamlMd5)) {
                return FormatToTarget.SYNC_FILE_ONLY;
            }
            if (!this.xmlHasSameHash(xmlMd5) && this.yamlHasSameHash(yamlMd5)) {
                return FormatToTarget.YAML;
            }
            if (this.xmlHasSameHash(xmlMd5) && !this.yamlHasSameHash(yamlMd5)) {
                return FormatToTarget.XML;
            }
        }
        return FormatToTarget.UNKNOWN;
    }

    public void save() {
        MD5 md5 = new MD5();
        SyncFile sync = new SyncFile();
        SyncFile.FileInfo xmlInfo = new SyncFile.FileInfo();
        xmlInfo.setSyncBy(System.getProperty("user.name"));
        xmlInfo.setTimestamp(this.xmlFile.lastModified());
        xmlInfo.setMd5(md5.hashFile(this.xmlFile));
        sync.setXml(xmlInfo);
        SyncFile.FileInfo yamlInfo = new SyncFile.FileInfo();
        yamlInfo.setSyncBy(System.getProperty("user.name"));
        yamlInfo.setTimestamp(this.yamlFile.lastModified());
        yamlInfo.setMd5(md5.hashFile(this.yamlFile));
        sync.setYaml(yamlInfo);
        Yaml yaml = new Yaml();
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.syncFile);
            yaml.dump(sync, writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean xmlHasSameTimestamp() {
        return this.sync.getXml().getTimestamp() == this.xmlFile.lastModified();
    }

    private boolean yamlHasSameTimestamp() {
        return this.sync.getYaml().getTimestamp() == this.yamlFile.lastModified();
    }

    private boolean xmlHasSameHash(String xmlHash) {
        return this.sync.getXml().getMd5().equals(xmlHash);
    }

    private boolean yamlHasSameHash(String yamlHash) {
        return this.sync.getYaml().getMd5().equals(yamlHash);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FormatToTarget {
        XML,
        YAML,
        SYNC_FILE_ONLY,
        UNKNOWN,
        NONE;

    }
}

