/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.yamlpom;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.twdata.maven.yamlpom.Converter;
import org.twdata.maven.yamlpom.ConverterOptions;
import org.twdata.maven.yamlpom.InvalidFormatException;
import org.twdata.maven.yamlpom.YamlToXmlConverter;
import org.twdata.maven.yamlpom.YamlUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.yaml.snakeyaml.Yaml;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlToYamlConverter
implements Converter {
    private static final int MAX_LINE_LENGTH = 120;
    private static final char[] INVALID_SCALAR_CHARACTERS = new char[]{':', '#', '[', ']', '{', '}', ',', '*', '\t'};
    private static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private static final ElementFilter ALL_ELEMENTS_FILTER;

    private void validateTargetContents(String yamlText) throws InvalidFormatException {
        Yaml yaml = YamlUtils.buildYaml();
        Object obj = null;
        try {
            obj = yaml.load(yamlText);
        }
        catch (RuntimeException ex) {
            throw new InvalidFormatException("Invalid YAML", yamlText, ex);
        }
        if (!(obj instanceof Map)) {
            throw new InvalidFormatException("YAML file not a map", yamlText);
        }
    }

    @Override
    public String convert(Reader xmlReader, ConverterOptions options) throws InvalidFormatException, IOException {
        StringWriter yamlWriter = new StringWriter();
        try {
            Document doc = factory.newDocumentBuilder().parse(new InputSource(xmlReader));
            Iterator<Element> it = XmlToYamlConverter.elementIterator(doc.getDocumentElement());
            while (it.hasNext()) {
                Element element = it.next();
                if ("modelVersion".equals(element.getTagName())) continue;
                this.convert(element, "", false, yamlWriter, options.getIndent());
            }
        }
        catch (SAXException e) {
            throw new InvalidFormatException("POM XML is not valid", null, e);
        }
        catch (ParserConfigurationException e) {
            throw new InvalidFormatException("POM XML is not valid", null, e);
        }
        String text = yamlWriter.toString();
        this.validateTargetContents(text);
        return text;
    }

    private void convert(Element element, String tabs, boolean isInList, Writer yamlWriter, String tab) throws IOException {
        block13: {
            String prefix;
            if (element == null) break block13;
            String name = element.getTagName();
            String string = prefix = isInList ? "- " : "";
            if ("configuration".equals(name) && this.isConfigurationNotYamlSafe(element, tabs, tab)) {
                yamlWriter.write(tabs + prefix + "configuration : |\n");
                StringWriter blockWriter = new StringWriter();
                Iterator<Element> i = XmlToYamlConverter.elementIterator(element);
                while (i.hasNext()) {
                    blockWriter.append(XmlToYamlConverter.elementToBlockString(i.next()));
                }
                yamlWriter.write(XmlToYamlConverter.indent(blockWriter.toString(), (isInList ? "  " : "") + tabs + tab, tab));
                return;
            }
            if (XmlToYamlConverter.elementList(element).isEmpty()) {
                yamlWriter.write(tabs + prefix + name + ": " + XmlToYamlConverter.sanitizeScalar(XmlToYamlConverter.trimmedContent(element)) + "\n");
            } else if (XmlToYamlConverter.isList(element)) {
                yamlWriter.write(tabs + prefix + name + ":");
                if (XmlToYamlConverter.shouldInline(element, (tabs + tab + "  ").length())) {
                    XmlToYamlConverter.printInlineList(element, yamlWriter);
                } else {
                    yamlWriter.write("\n");
                    Iterator<Element> i = XmlToYamlConverter.elementIterator(element);
                    while (i.hasNext()) {
                        Element list = i.next();
                        if (XmlToYamlConverter.shouldInline(list, (tabs + tab + "  ").length())) {
                            XmlToYamlConverter.printInlineMap(list, tabs + tab + "- ", yamlWriter);
                            continue;
                        }
                        if (XmlToYamlConverter.elementList(list).isEmpty()) {
                            yamlWriter.write(tabs + tab + "- " + XmlToYamlConverter.trimmedContent(list) + "\n");
                            continue;
                        }
                        boolean isFirst = true;
                        Iterator<Element> it = XmlToYamlConverter.elementIterator(list);
                        while (it.hasNext()) {
                            Element listItem = it.next();
                            this.convert(listItem, (!isFirst ? "  " : "") + tabs + tab, isFirst, yamlWriter, tab);
                            isFirst = false;
                        }
                    }
                }
            } else {
                yamlWriter.write(tabs + prefix + name + ":\n");
                Iterator<Element> i = XmlToYamlConverter.elementIterator(element);
                while (i.hasNext()) {
                    this.convert(i.next(), (isInList ? "  " : "") + tabs + tab, false, yamlWriter, tab);
                }
            }
        }
    }

    private boolean isConfigurationNotYamlSafe(Element element, String tabs, String tab) throws IOException {
        StringWriter configWriter = new StringWriter();
        Element testing = element.getOwnerDocument().createElement("testing");
        for (Element kid : XmlToYamlConverter.elementList(element)) {
            testing.appendChild(kid.cloneNode(true));
        }
        this.convert(testing, tabs + tab, false, configWriter, tab);
        try {
            String configAsXml = new YamlToXmlConverter().convert(new StringReader(configWriter.toString()), new ConverterOptions());
            Document doc = factory.newDocumentBuilder().parse(new InputSource(new StringReader(configAsXml)));
            Element config = (Element)doc.getDocumentElement().getElementsByTagName("testing").item(0);
            return !XmlToYamlConverter.areElementsEqual(testing, config);
        }
        catch (InvalidFormatException e) {
            return true;
        }
        catch (RuntimeException ex) {
            return true;
        }
        catch (SAXException e) {
            return true;
        }
        catch (ParserConfigurationException e) {
            return true;
        }
    }

    static String elementToBlockString(Element root) throws IOException {
        StringWriter out = new StringWriter();
        TransformerFactory tfactory = TransformerFactory.newInstance();
        try {
            Transformer serializer = tfactory.newTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("omit-xml-declaration", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource xmlSource = new DOMSource(root);
            StreamResult outputTarget = new StreamResult(out);
            serializer.transform(xmlSource, outputTarget);
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return out.toString();
    }

    static String indent(String text, String indent, String tab) {
        String[] lines;
        int oldIndent = 0;
        StringWriter block = new StringWriter();
        for (String line : lines = text.split("\n")) {
            block.write(indent);
            if (oldIndent == 0) {
                oldIndent = XmlToYamlConverter.firstNonSpace(line);
            }
            if (oldIndent > 0) {
                int firstNonSpace = XmlToYamlConverter.firstNonSpace(line);
                line = firstNonSpace >= oldIndent ? tab + line.substring(oldIndent) : line.substring(firstNonSpace);
            }
            block.write(line);
            block.write("\n");
        }
        return block.toString();
    }

    static int firstNonSpace(String text) {
        int pos = 0;
        for (int x = 0; x < text.length() && text.charAt(x) == ' '; ++x) {
            ++pos;
        }
        return pos;
    }

    static boolean areElementsEqual(Element e1, Element e2) {
        String text2;
        String text1;
        int x;
        if (e1.getAttributes().getLength() == e2.getAttributes().getLength()) {
            NamedNodeMap attrs1 = e1.getAttributes();
            NamedNodeMap attrs2 = e2.getAttributes();
            for (x = 0; x < attrs1.getLength(); ++x) {
                Attr a1 = (Attr)attrs1.item(x);
                Attr a2 = (Attr)attrs2.item(x);
                if (a1.getName().equals(a2.getName()) && a1.getValue().equals(a2.getValue())) continue;
                return false;
            }
        } else {
            return false;
        }
        List<Element> kids1 = XmlToYamlConverter.elementList(e1);
        List<Element> kids2 = XmlToYamlConverter.elementList(e2);
        if (kids1.isEmpty() && kids2.isEmpty() && !(text1 = XmlToYamlConverter.trimmedContent(e1)).equals(text2 = XmlToYamlConverter.trimmedContent(e2))) {
            return false;
        }
        if (kids1.size() == kids2.size()) {
            for (x = 0; x < kids1.size(); ++x) {
                if (XmlToYamlConverter.areElementsEqual(kids1.get(x), kids2.get(x))) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private static String sanitizeScalar(String val) {
        boolean needsQuoted = false;
        for (char forbiddenChar : INVALID_SCALAR_CHARACTERS) {
            if (val.indexOf(forbiddenChar) <= -1) continue;
            needsQuoted = true;
        }
        if (needsQuoted) {
            val = XmlToYamlConverter.convertToQuoted(val);
        }
        return val;
    }

    private static String convertToQuoted(String val) {
        val = val.replaceAll("\\\\", "\\\\");
        val = val.replaceAll("\"", "\\\"");
        val = "\"" + val + "\"";
        return val;
    }

    private static void printInlineMap(Element listItem, String tab, Writer yamlWriter) throws IOException {
        yamlWriter.write(tab + "{ ");
        Iterator<Element> i = XmlToYamlConverter.elementIterator(listItem);
        while (i.hasNext()) {
            Element e = i.next();
            yamlWriter.write(e.getTagName() + ": " + XmlToYamlConverter.sanitizeScalar(XmlToYamlConverter.trimmedContent(e)));
            if (!i.hasNext()) continue;
            yamlWriter.write(", ");
        }
        yamlWriter.write(" }\n");
    }

    private static void printInlineList(Element listItem, Writer yamlWriter) throws IOException {
        yamlWriter.write(" [ ");
        Iterator<Element> i = XmlToYamlConverter.elementIterator(listItem);
        while (i.hasNext()) {
            Element e = i.next();
            yamlWriter.write(XmlToYamlConverter.sanitizeScalar(XmlToYamlConverter.trimmedContent(e)));
            if (!i.hasNext()) continue;
            yamlWriter.write(", ");
        }
        yamlWriter.write(" ]\n");
    }

    private static boolean shouldInline(Element element, int startLength) {
        int length;
        Element e;
        if (XmlToYamlConverter.elementList(element).isEmpty()) {
            return false;
        }
        Iterator<Element> i = XmlToYamlConverter.elementIterator(element);
        for (length = startLength; i.hasNext() && length < 120; length += (e.getTagName() + ": " + XmlToYamlConverter.trimmedContent(e)).length()) {
            e = i.next();
            if (XmlToYamlConverter.elementList(element).isEmpty()) continue;
            length = Integer.MAX_VALUE;
            break;
        }
        return length < 120;
    }

    private static boolean isList(Element element) {
        String name = element.getTagName();
        return name.endsWith("s") && XmlToYamlConverter.hasChildElement(element, name.substring(0, name.length() - 1)) || name.endsWith("ies") && XmlToYamlConverter.hasChildElement(element, name.substring(0, name.length() - 3) + "y");
    }

    private static String trimmedContent(Element e) {
        String content = e.getTextContent();
        return content != null ? content.trim() : "";
    }

    private static boolean hasChildElement(Element e, final String tagName) {
        return !XmlToYamlConverter.elementList(e, new ElementFilter(){

            public boolean shouldInclude(Element e) {
                return e.getTagName().equals(tagName);
            }
        }).isEmpty();
    }

    private static Iterator<Element> elementIterator(Element root) {
        return XmlToYamlConverter.elementList(root).iterator();
    }

    private static List<Element> elementList(Element root) {
        return XmlToYamlConverter.elementList(root, ALL_ELEMENTS_FILTER);
    }

    private static List<Element> elementList(Element root, ElementFilter filter) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList nl = root.getChildNodes();
        for (int x = 0; x < nl.getLength(); ++x) {
            Element e;
            if (nl.item(x).getNodeType() != 1 || !filter.shouldInclude(e = (Element)nl.item(x))) continue;
            result.add(e);
        }
        return result;
    }

    static {
        factory.setIgnoringComments(false);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setCoalescing(false);
        factory.setValidating(false);
        ALL_ELEMENTS_FILTER = new ElementFilter(){

            public boolean shouldInclude(Element e) {
                return true;
            }
        };
    }

    private static interface ElementFilter {
        public boolean shouldInclude(Element var1);
    }
}

