/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.yamlpom;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.IOUtils;
import org.twdata.maven.yamlpom.Converter;
import org.twdata.maven.yamlpom.ConverterOptions;
import org.twdata.maven.yamlpom.InvalidFormatException;
import org.twdata.maven.yamlpom.YamlUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.yaml.snakeyaml.Yaml;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlToXmlConverter
implements Converter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String convert(Reader from, ConverterOptions options) throws InvalidFormatException, IOException {
        StringWriter xmlWriter = null;
        String tab = options.getIndent();
        try {
            xmlWriter = new StringWriter();
            Yaml yaml = YamlUtils.buildYaml();
            Object yamlPom = yaml.load(from);
            xmlWriter.write("<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n" + tab + "<modelVersion>4.0.0</modelVersion>\n");
            this.convert((Map)yamlPom, tab, xmlWriter, options.getIndent());
            xmlWriter.write("</project>\n");
        }
        finally {
            IOUtils.closeQuietly(xmlWriter);
        }
        String text = xmlWriter.toString();
        this.validateTargetContents(text);
        return text;
    }

    private void validateTargetContents(String text) throws InvalidFormatException {
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(new InputSource(new StringReader(text)), new DefaultHandler());
        }
        catch (SAXException e) {
            throw new InvalidFormatException("Target XML is not well-formed", text, e);
        }
        catch (ParserConfigurationException e) {
            throw new InvalidFormatException("Target XML is not well-formed", text, e);
        }
        catch (IOException e) {
            throw new InvalidFormatException("Target XML is not well-formed", text, e);
        }
    }

    private void convert(Map<String, Object> map, String tabs, Writer writer, String tab) throws IOException {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey().trim();
            Object value = entry.getValue();
            if (value instanceof Map) {
                writer.write(tabs);
                writer.write("<" + key + ">\n");
                this.convert((Map)value, tabs + tab, writer, tab);
                writer.write(tabs);
                writer.write("</" + key + ">\n");
                continue;
            }
            if (value instanceof Collection) {
                writer.write(tabs + "<" + key + ">\n");
                String singleName = key.endsWith("ies") ? key.substring(0, key.length() - 3) + "y" : key.substring(0, key.length() - 1);
                for (Object item : (Collection)value) {
                    if (item instanceof Map) {
                        writer.write(tabs + tab + "<" + singleName + ">\n");
                        this.convert((Map)item, tabs + tab + tab, writer, tab);
                        writer.write(tabs + tab + "</" + singleName + ">\n");
                        continue;
                    }
                    writer.write(tabs + tab + "<" + singleName + ">" + YamlToXmlConverter.text(item) + "</" + singleName + ">\n");
                }
                writer.write(tabs + "</" + key + ">\n");
                continue;
            }
            String text = YamlToXmlConverter.indent(value != null ? value.toString() : "", tabs + tab);
            if (text.endsWith("\n")) {
                text = text + tabs;
            }
            writer.write(tabs + "<" + key + ">" + YamlToXmlConverter.text(text) + "</" + key + ">\n");
        }
    }

    static String text(Object obj) {
        String text = obj.toString();
        if (text.indexOf("<") > -1 && text.indexOf("<![CDATA[") == -1) {
            return "<![CDATA[" + text + "]]>";
        }
        return text;
    }

    static String indent(String text, String tab) {
        StringWriter block = new StringWriter();
        String[] lines = text.split("\n");
        if (lines.length > 1) {
            for (String line : lines) {
                block.write(tab);
                block.write(line);
                block.write("\n");
            }
        } else {
            block.write(text);
        }
        return block.toString();
    }
}

