/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.yaml.snakeyaml.Loader;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.reader.UnicodeReader;
import org.yaml.snakeyaml.resolver.Resolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanParser {
    private JavaBeanParser() {
    }

    public static <T> T load(String yaml, Class<T> javabean) {
        Loader loader = JavaBeanParser.createLoader(javabean);
        return (T)loader.load(new StringReader(yaml));
    }

    public static <T> T load(InputStream io, Class<T> javabean) {
        Loader loader = JavaBeanParser.createLoader(javabean);
        return (T)loader.load(new UnicodeReader(io));
    }

    public static <T> T load(Reader io, Class<T> javabean) {
        Loader loader = JavaBeanParser.createLoader(javabean);
        return (T)loader.load(io);
    }

    private static Loader createLoader(Class<? extends Object> clazz) {
        Loader loader = new Loader(new Constructor(clazz));
        Resolver resolver = new Resolver();
        loader.setResolver(resolver);
        return loader;
    }
}

