/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.task;

import com.atlassian.core.task.FifoBuffer;
import com.atlassian.core.task.Task;
import com.atlassian.core.task.TaskQueue;
import java.sql.Timestamp;
import java.util.Collection;
import org.apache.log4j.Logger;

public abstract class AbstractTaskQueue
implements TaskQueue {
    private static final transient Logger log = Logger.getLogger(AbstractTaskQueue.class);
    protected FifoBuffer buffer;
    private boolean flushing;
    private Timestamp flushStarted;

    public AbstractTaskQueue(FifoBuffer buffer) {
        this.buffer = buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.flushing) {
            return;
        }
        this.flushing = true;
        this.flushStarted = new Timestamp(System.currentTimeMillis());
        try {
            Task task;
            while ((task = (Task)this.buffer.remove()) != null) {
                log.debug((Object)("Executing: " + task));
                try {
                    task.execute();
                }
                catch (Exception e) {
                    this.handleException(task, e);
                }
            }
        }
        finally {
            this.flushing = false;
            this.flushStarted = null;
        }
    }

    protected void handleException(Task task, Exception e) {
        log.error((Object)("Failed to execute task : " + task), (Throwable)e);
    }

    public int size() {
        return this.buffer.size();
    }

    public void addTask(Task task) {
        log.debug((Object)("Queued: " + task));
        this.buffer.add(task);
    }

    public Collection getQueue() {
        return this.buffer.getItems();
    }

    public boolean isFlushing() {
        return this.flushing;
    }

    public Timestamp getFlushStarted() {
        return this.flushStarted;
    }

    public void clear() {
        this.buffer.clear();
    }

    public Collection getTasks() {
        return this.buffer.getItems();
    }
}

