/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.util;

import com.opensymphony.module.oscache.base.Cache;
import com.opensymphony.module.oscache.web.ServletCacheAdministrator;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Category;

public class CacheUtils {
    private static final Category log = Category.getInstance(CacheUtils.class);

    public static void flushCache(String key) {
        try {
            Map applicationCaches = ServletCacheAdministrator.getApplicationCaches();
            for (Map.Entry entry : applicationCaches.entrySet()) {
                Cache cache = (Cache)entry.getValue();
                cache.flushPattern(key);
            }
            Map sessionCaches = ServletCacheAdministrator.getSessionCaches();
            for (Map.Entry entry : sessionCaches.entrySet()) {
                Cache cache = (Cache)entry.getValue();
                cache.flushPattern(key);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error flushing caches matching key : " + key + " : " + e), (Throwable)e);
        }
    }

    public static void flushAll() {
        try {
            Map applicationCaches = ServletCacheAdministrator.getApplicationCaches();
            for (Map.Entry entry : applicationCaches.entrySet()) {
                Cache cache = (Cache)entry.getValue();
                cache.flushAll(new Date());
            }
            Map sessionCaches = ServletCacheAdministrator.getSessionCaches();
            for (Map.Entry entry : sessionCaches.entrySet()) {
                Cache cache = (Cache)entry.getValue();
                cache.flushAll(new Date());
            }
        }
        catch (Exception e) {
            log.error((Object)("Error flushing all caches: " + e), (Throwable)e);
        }
    }
}

