/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.oscache.base;

import com.opensymphony.module.oscache.base.CacheEntry;
import com.opensymphony.module.oscache.base.EntryRefreshPolicy;
import com.opensymphony.module.oscache.base.NeedsRefreshException;
import com.opensymphony.module.oscache.base.algorithm.AbstractConcurrentReadCache;
import com.opensymphony.module.oscache.base.algorithm.LRUCache;
import com.opensymphony.module.oscache.base.algorithm.UnlimitedCache;
import com.opensymphony.module.oscache.base.events.CacheEntryEvent;
import com.opensymphony.module.oscache.base.events.CacheEntryEventListener;
import com.opensymphony.module.oscache.base.events.CacheEntryEventType;
import com.opensymphony.module.oscache.base.events.CacheMapAccessEvent;
import com.opensymphony.module.oscache.base.events.CacheMapAccessEventListener;
import com.opensymphony.module.oscache.base.events.CacheMapAccessEventType;
import com.opensymphony.module.oscache.base.persistence.PersistenceListener;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import javax.swing.event.EventListenerList;

public class Cache
implements Serializable {
    private AbstractConcurrentReadCache cacheMap = null;
    private Date flushDateTime = null;
    protected EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$com$opensymphony$module$oscache$base$events$CacheEntryEventListener;
    static /* synthetic */ Class class$com$opensymphony$module$oscache$base$events$CacheMapAccessEventListener;

    public Cache(boolean bl, boolean bl2) {
        this.cacheMap = new UnlimitedCache();
        this.cacheMap.setMemoryCaching(bl);
        this.cacheMap.setUnlimitedDiskCache(bl2);
    }

    public Cache(boolean bl, boolean bl2, String string, int n) {
        if (string != null && string.length() > 0 && n > 0) {
            try {
                this.cacheMap = (AbstractConcurrentReadCache)Class.forName(string).newInstance();
                this.cacheMap.setMaxEntries(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.cacheMap == null) {
            this.cacheMap = n > 0 ? new LRUCache(n) : new UnlimitedCache();
        }
        this.cacheMap.setUnlimitedDiskCache(bl2);
        this.cacheMap.setMemoryCaching(bl);
    }

    protected CacheEntry getCacheEntry(String string, EntryRefreshPolicy entryRefreshPolicy) {
        CacheEntry cacheEntry = null;
        if (string != null && string.length() > 0) {
            cacheEntry = (CacheEntry)this.cacheMap.get(string);
            if (cacheEntry == null) {
                cacheEntry = new CacheEntry(string, entryRefreshPolicy);
                this.dispatchCacheMapAccessEvent(CacheMapAccessEventType.MISS, cacheEntry);
                this.dispatchCacheEntryEvent(CacheEntryEventType.ENTRY_ADDED, string, cacheEntry);
            }
        } else {
            throw new IllegalArgumentException("getCacheEntry called with an empty ornull key");
        }
        this.dispatchCacheMapAccessEvent(CacheMapAccessEventType.HIT, cacheEntry);
        return cacheEntry;
    }

    public void flushPattern(String string) {
        if (string != null && string.length() > 0) {
            String string2 = null;
            CacheEntry cacheEntry = null;
            Iterator iterator = this.cacheMap.keySet().iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                if (string2.indexOf(string) < 0 || (cacheEntry = (CacheEntry)this.cacheMap.get(string2)) == null) continue;
                this.flushEntry(cacheEntry);
            }
        }
    }

    public void flushAll(Date date) {
        this.flushDateTime = date;
    }

    public boolean isFlushed(CacheEntry cacheEntry) {
        if (this.flushDateTime != null) {
            long l = cacheEntry.getLastUpdate();
            return this.flushDateTime.getTime() >= l;
        }
        return false;
    }

    public void flushEntry(String string) {
        this.flushEntry(this.getCacheEntry(string, null));
    }

    private void flushEntry(CacheEntry cacheEntry) {
        String string = cacheEntry.getKey();
        cacheEntry.flush();
        this.cacheMap.put(string, cacheEntry);
        this.dispatchCacheEntryEvent(CacheEntryEventType.ENTRY_FLUSHED, string, cacheEntry);
    }

    public void putInCache(String string, Object object, EntryRefreshPolicy entryRefreshPolicy) {
        CacheEntry cacheEntry = this.getCacheEntry(string, entryRefreshPolicy);
        cacheEntry.setContent(object);
        this.cacheMap.put(string, cacheEntry);
        this.dispatchCacheEntryEvent(CacheEntryEventType.ENTRY_UPDATED, string, cacheEntry);
    }

    public void putInCache(String string, Object object) {
        this.putInCache(string, object, null);
    }

    public Object getFromCache(String string, int n) throws NeedsRefreshException {
        CacheEntry cacheEntry = this.getCacheEntry(string, null);
        Object object = cacheEntry.getContent();
        if (cacheEntry.needsRefresh(n) || this.isFlushed(cacheEntry)) {
            throw new NeedsRefreshException(object);
        }
        return object;
    }

    protected void clear() {
        this.cacheMap.clear();
    }

    public void addCacheEntryEventListener(CacheEntryEventListener cacheEntryEventListener) {
        this.listenerList.add(class$com$opensymphony$module$oscache$base$events$CacheEntryEventListener == null ? (class$com$opensymphony$module$oscache$base$events$CacheEntryEventListener = Cache.class$("com.opensymphony.module.oscache.base.events.CacheEntryEventListener")) : class$com$opensymphony$module$oscache$base$events$CacheEntryEventListener, cacheEntryEventListener);
    }

    public void removeCacheEntryEventListener(CacheEntryEventListener cacheEntryEventListener) {
        this.listenerList.remove(class$com$opensymphony$module$oscache$base$events$CacheEntryEventListener == null ? (class$com$opensymphony$module$oscache$base$events$CacheEntryEventListener = Cache.class$("com.opensymphony.module.oscache.base.events.CacheEntryEventListener")) : class$com$opensymphony$module$oscache$base$events$CacheEntryEventListener, cacheEntryEventListener);
    }

    private void dispatchCacheEntryEvent(CacheEntryEventType cacheEntryEventType, String string, CacheEntry cacheEntry) {
        CacheEntryEvent cacheEntryEvent = new CacheEntryEvent(this, cacheEntry);
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$opensymphony$module$oscache$base$events$CacheEntryEventListener == null ? Cache.class$("com.opensymphony.module.oscache.base.events.CacheEntryEventListener") : class$com$opensymphony$module$oscache$base$events$CacheEntryEventListener)) {
                if (cacheEntryEventType.equals(CacheEntryEventType.ENTRY_ADDED)) {
                    ((CacheEntryEventListener)objectArray[n + 1]).cacheEntryAdded(cacheEntryEvent);
                } else if (cacheEntryEventType.equals(CacheEntryEventType.ENTRY_UPDATED)) {
                    ((CacheEntryEventListener)objectArray[n + 1]).cacheEntryUpdated(cacheEntryEvent);
                } else if (cacheEntryEventType.equals(CacheEntryEventType.ENTRY_REMOVED)) {
                    ((CacheEntryEventListener)objectArray[n + 1]).cacheEntryRemoved(cacheEntryEvent);
                } else if (cacheEntryEventType.equals(CacheEntryEventType.ENTRY_FLUSHED)) {
                    ((CacheEntryEventListener)objectArray[n + 1]).cacheEntryFlushed(cacheEntryEvent);
                }
            }
            n -= 2;
        }
    }

    public void addCacheMapAccessEventListener(CacheMapAccessEventListener cacheMapAccessEventListener) {
        this.listenerList.add(class$com$opensymphony$module$oscache$base$events$CacheMapAccessEventListener == null ? (class$com$opensymphony$module$oscache$base$events$CacheMapAccessEventListener = Cache.class$("com.opensymphony.module.oscache.base.events.CacheMapAccessEventListener")) : class$com$opensymphony$module$oscache$base$events$CacheMapAccessEventListener, cacheMapAccessEventListener);
    }

    public void removeCacheMapAccessEventListener(CacheMapAccessEventListener cacheMapAccessEventListener) {
        this.listenerList.remove(class$com$opensymphony$module$oscache$base$events$CacheMapAccessEventListener == null ? (class$com$opensymphony$module$oscache$base$events$CacheMapAccessEventListener = Cache.class$("com.opensymphony.module.oscache.base.events.CacheMapAccessEventListener")) : class$com$opensymphony$module$oscache$base$events$CacheMapAccessEventListener, cacheMapAccessEventListener);
    }

    private void dispatchCacheMapAccessEvent(CacheMapAccessEventType cacheMapAccessEventType, CacheEntry cacheEntry) {
        CacheMapAccessEvent cacheMapAccessEvent = new CacheMapAccessEvent(cacheMapAccessEventType, cacheEntry);
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$opensymphony$module$oscache$base$events$CacheMapAccessEventListener == null ? Cache.class$("com.opensymphony.module.oscache.base.events.CacheMapAccessEventListener") : class$com$opensymphony$module$oscache$base$events$CacheMapAccessEventListener)) {
                ((CacheMapAccessEventListener)objectArray[n + 1]).accessed(cacheMapAccessEvent);
            }
            n -= 2;
        }
    }

    public void setPersistenceListener(PersistenceListener persistenceListener) {
        this.cacheMap.setPersistenceListener(persistenceListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

