/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.oscache.base.persistence;

import com.opensymphony.module.oscache.base.persistence.CachePersistenceException;
import com.opensymphony.module.oscache.base.persistence.PersistenceListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class DiskPersistenceListener
implements PersistenceListener {
    private static final String FILE_SEPARATOR_KEY = "file.separator";
    private static final String CACHE_EXTENSION = "cache";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    protected static final char FILE_SEPARATOR_CHAR = System.getProperty("file.separator").charAt(0);
    private String root = null;

    public DiskPersistenceListener(String string) {
        this.root = string;
    }

    /*
     * Loose catch block
     */
    public void store(String string, Object object) throws CachePersistenceException {
        block15: {
            File file = this.getCacheFile(string);
            File file2 = new File(file.getParent());
            try {
                if (!file2.exists()) {
                    file2.mkdirs();
                }
            }
            catch (Exception exception) {
                throw new CachePersistenceException("Unable to create to required directory" + file2);
            }
            while (file.exists() && !file.delete()) {
            }
            FileOutputStream fileOutputStream = null;
            ObjectOutputStream objectOutputStream = null;
            fileOutputStream = new FileOutputStream(file);
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            Object var9_8 = null;
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                objectOutputStream.close();
            }
            catch (Exception exception) {}
            break block15;
            {
                catch (Exception exception) {
                    throw new CachePersistenceException("Unable to write (" + string + ") in the cache");
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    objectOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public Object retrieve(String string) throws CachePersistenceException {
        Object object;
        block14: {
            boolean bl;
            File file = this.getCacheFile(string);
            object = null;
            try {
                bl = file.exists();
            }
            catch (Exception exception) {
                throw new CachePersistenceException("Unable to verify if " + file + " exists");
            }
            if (bl) {
                BufferedInputStream bufferedInputStream = null;
                ObjectInputStream objectInputStream = null;
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                objectInputStream = new ObjectInputStream(bufferedInputStream);
                object = objectInputStream.readObject();
                Object var9_8 = null;
                try {
                    objectInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    bufferedInputStream.close();
                }
                catch (Exception exception) {}
                break block14;
                {
                    catch (Exception exception) {
                        throw new CachePersistenceException("Unable to read (" + string + ") from the cache");
                    }
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    try {
                        objectInputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        bufferedInputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return object;
    }

    public void remove(String string) throws CachePersistenceException {
        try {
            File file = this.getCacheFile(string);
            while (!file.delete() && file.exists()) {
            }
        }
        catch (Exception exception) {
            throw new CachePersistenceException("Unable to remove (" + string + ") from the cache");
        }
    }

    public void clear() throws CachePersistenceException {
        this.clear(this.root);
    }

    private void clear(String string) throws CachePersistenceException {
        File file = new File(string);
        File[] fileArray = file.listFiles();
        try {
            if (fileArray != null) {
                int n = 0;
                while (n < fileArray.length) {
                    if (fileArray[n].isFile()) {
                        fileArray[n].delete();
                    } else {
                        this.clear(fileArray[n].toString());
                        fileArray[n].delete();
                    }
                    ++n;
                }
            }
            file.delete();
        }
        catch (Exception exception) {
            throw new CachePersistenceException("Unable to clear the cache directory");
        }
    }

    public boolean isStored(String string) throws CachePersistenceException {
        try {
            File file = this.getCacheFile(string);
            return file.exists();
        }
        catch (Exception exception) {
            throw new CachePersistenceException("Unable verify id (" + string + ") is stored in the cache");
        }
    }

    private File getCacheFile(String string) {
        StringBuffer stringBuffer;
        File file = null;
        if (string != null && string.length() > 0) {
            stringBuffer = new StringBuffer(30);
            string = string.replace('/', FILE_SEPARATOR_CHAR);
            stringBuffer.append(this.root).append(FILE_SEPARATOR);
            if (string.charAt(0) != FILE_SEPARATOR_CHAR) {
                stringBuffer.append(FILE_SEPARATOR_CHAR);
            }
            stringBuffer.append(string);
            if (string.endsWith(FILE_SEPARATOR)) {
                stringBuffer.append(CACHE_EXTENSION);
            }
        } else {
            throw new IllegalArgumentException("Invalid key specified to getCacheFile.");
        }
        stringBuffer.append(".cache");
        file = new File(stringBuffer.toString());
        return file;
    }
}

