/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.jira;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.product.jira.AbstractJiraDatabase;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class JiraDatabaseMssqlImpl
extends AbstractJiraDatabase {
    private static final String DROP_DATABASE = "DROP DATABASE %s;";
    private static final String DROP_USER = ";";
    private static final String CREATE_DATABASE = "CREATE DATABASE %s;";
    private static final String CREATE_USER = "";
    private static final String GRANT_PERMISSION = "";

    public JiraDatabaseMssqlImpl(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected String dropDatabase() throws MojoExecutionException {
        return String.format(DROP_DATABASE, this.getDatabaseName(this.getDataSource().getUrl()));
    }

    @Override
    protected String dropUser() {
        return String.format(DROP_USER, this.getDataSource().getUsername());
    }

    @Override
    protected String createDatabase() throws MojoExecutionException {
        return String.format(CREATE_DATABASE, this.getDatabaseName(this.getDataSource().getUrl()));
    }

    @Override
    protected String createUser() {
        return String.format("", this.getDataSource().getUsername(), this.getDataSource().getPassword());
    }

    @Override
    protected String grantPermissionForUser() throws MojoExecutionException {
        return String.format("", this.getDatabaseName(this.getDataSource().getUrl()), this.getDataSource().getUsername());
    }

    @Override
    protected String getDatabaseName(String url) throws MojoExecutionException {
        try {
            Class.forName(this.getDataSource().getDriver());
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Could not load JTDS MSSQL database library to classpath");
        }
        try {
            Driver driver = DriverManager.getDriver(url);
            DriverPropertyInfo[] driverPropertyInfos = driver.getPropertyInfo(url, null);
            if (null != driverPropertyInfos) {
                for (DriverPropertyInfo driverPropertyInfo : driverPropertyInfos) {
                    if (!"DATABASENAME".equals(driverPropertyInfo.name)) continue;
                    return driverPropertyInfo.value;
                }
            }
        }
        catch (SQLException e) {
            throw new MojoExecutionException("");
        }
        return null;
    }

    @Override
    public Xpp3Dom getPluginConfiguration() throws MojoExecutionException {
        String sql = this.dropDatabase() + this.dropUser() + this.createDatabase() + this.createUser() + this.grantPermissionForUser();
        Xpp3Dom pluginConfiguration = this.baseConfiguration();
        pluginConfiguration.addChild(MojoExecutor.element(MojoExecutor.name("sqlCommand"), sql).toDom());
        return pluginConfiguration;
    }
}

