/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.jira;

public enum JiraDatabaseType {
    HSQL("hsql", true, "jdbc:hsqldb", "org.hsqldb.jdbcDriver", "org.hsqldb:hsqldb"),
    H2("h2", true, "jdbc:h2", "org.h2.Driver", "com.h2database:h2"),
    MYSQL("mysql", false, "jdbc:mysql", "com.mysql.jdbc.Driver", "mysql:mysql-connector-java"),
    POSTGRES("postgres72", true, "jdbc:postgresql", "org.postgresql.Driver", "org.postgresql:postgresql"),
    ORACLE("oracle10g", false, "jdbc:oracle", "oracle.jdbc.OracleDriver", "com.oracle:ojdbc6"),
    MSSQL("mssql", true, "jdbc:sqlserver", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "net.sourceforge.jtds:jtds"),
    MSSQL_JTDS("mssql", true, "jdbc:jtds", "net.sourceforge.jtds.jdbc.Driver", "net.sourceforge.jtds:jtds");

    private final String dbType;
    private final boolean hasSchema;
    private final String uriPrefix;
    private final String driverClassName;
    private final String libArtifact;

    public static JiraDatabaseType getDatabaseType(String uriPrefix, String driverClassName) {
        for (JiraDatabaseType databaseType : JiraDatabaseType.values()) {
            if (!databaseType.accept(uriPrefix) || !databaseType.driverClassName.equals(driverClassName)) continue;
            return databaseType;
        }
        return null;
    }

    private JiraDatabaseType(String dbType, boolean hasSchema, String uriPrefix, String driverClassName, String libArtifact) {
        this.dbType = dbType;
        this.hasSchema = hasSchema;
        this.uriPrefix = uriPrefix;
        this.driverClassName = driverClassName;
        this.libArtifact = libArtifact;
    }

    private boolean accept(String uri) {
        return null != uri && uri.trim().startsWith(this.uriPrefix);
    }

    public String getDbType() {
        return this.dbType;
    }

    public boolean hasSchema() {
        return this.hasSchema;
    }

    public String getLibArtifact() {
        return this.libArtifact;
    }

    public String toString() {
        return super.toString();
    }
}

