/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.codegen;

import com.atlassian.maven.plugins.amps.codegen.PluginModuleSelectionQueryer;
import com.atlassian.plugins.codegen.modules.PluginModuleCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jline.ANSIBuffer;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class DefaultPluginModuleSelectionQueryer
extends AbstractLogEnabled
implements PluginModuleSelectionQueryer {
    public static final List<String> YN_ANSWERS = new ArrayList<String>(Arrays.asList("Y", "y", "N", "n"));
    private Prompter prompter;
    private boolean useAnsiColor;

    public DefaultPluginModuleSelectionQueryer() {
        String mavencolor = System.getenv("MAVEN_COLOR");
        this.useAnsiColor = mavencolor != null && !mavencolor.equals("") ? Boolean.parseBoolean(mavencolor) : false;
    }

    @Override
    public PluginModuleCreator selectModule(Map<Class, PluginModuleCreator> map) throws PrompterException {
        if (this.useAnsiColor) {
            return this.getAnsiModule(map);
        }
        return this.getPlainModule(map);
    }

    private PluginModuleCreator getAnsiModule(Map<Class, PluginModuleCreator> map) throws PrompterException {
        ANSIBuffer query = new ANSIBuffer();
        query.bold("Choose Plugin Module:\n");
        ArrayList<String> answers = new ArrayList<String>();
        HashMap<String, PluginModuleCreator> moduleAnswerMap = new HashMap<String, PluginModuleCreator>();
        int counter = 1;
        for (Map.Entry<Class, PluginModuleCreator> entry : map.entrySet()) {
            PluginModuleCreator moduleCreator = entry.getValue();
            String answer = String.valueOf(counter);
            query.bold(answer);
            if (counter < 10) {
                query.append(":  ");
            } else {
                query.append(": ");
            }
            query.append(entry.getValue().getModuleName() + "\n");
            answers.add(answer);
            moduleAnswerMap.put(answer, moduleCreator);
            ++counter;
        }
        query.bold("Choose a number");
        String answer = this.prompter.prompt(query.toString(), answers);
        PluginModuleCreator selection = (PluginModuleCreator)moduleAnswerMap.get(answer);
        return selection;
    }

    private PluginModuleCreator getPlainModule(Map<Class, PluginModuleCreator> map) throws PrompterException {
        StringBuilder query = new StringBuilder("Choose Plugin Module:\n");
        ArrayList<String> answers = new ArrayList<String>();
        HashMap<String, PluginModuleCreator> moduleAnswerMap = new HashMap<String, PluginModuleCreator>();
        int counter = 1;
        for (Map.Entry<Class, PluginModuleCreator> entry : map.entrySet()) {
            PluginModuleCreator moduleCreator = entry.getValue();
            String answer = String.valueOf(counter);
            if (counter < 10) {
                query.append(answer + ":  ");
            } else {
                query.append(answer + ": ");
            }
            query.append(entry.getValue().getModuleName() + "\n");
            answers.add(answer);
            moduleAnswerMap.put(answer, moduleCreator);
            ++counter;
        }
        query.append("Choose a number");
        String answer = this.prompter.prompt(query.toString(), answers);
        PluginModuleCreator selection = (PluginModuleCreator)moduleAnswerMap.get(answer);
        return selection;
    }

    @Override
    public boolean addAnotherModule() throws PrompterException {
        return this.promptForBoolean("Add Another Plugin Module?", "N");
    }

    public void setPrompter(Prompter prompter) {
        this.prompter = prompter;
    }

    protected boolean promptForBoolean(String message, String defaultValue) throws PrompterException {
        String answer = StringUtils.isBlank((String)defaultValue) ? this.prompter.prompt(message, YN_ANSWERS) : this.prompter.prompt(message, YN_ANSWERS, defaultValue);
        boolean bool = "y".equals(answer.toLowerCase());
        return bool;
    }
}

