/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsAst;
import com.google.javascript.jscomp.JsMessage;
import com.google.javascript.jscomp.JsMessageDefinition;
import com.google.javascript.jscomp.JsMessageVisitor;
import com.google.javascript.jscomp.LightweightMessageFormatter;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.rhino.Node;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public class JsMessageExtractor {
    private final JsMessage.Style style;
    private final JsMessage.IdGenerator idGenerator;

    public JsMessageExtractor(JsMessage.IdGenerator idGenerator, JsMessage.Style style) {
        this.idGenerator = idGenerator;
        this.style = style;
    }

    public Collection<JsMessage> extractMessages(SourceFile ... inputs) throws IOException {
        return this.extractMessages((Iterable)ImmutableList.copyOf((Object[])inputs));
    }

    public <T extends SourceFile> Collection<JsMessage> extractMessages(Iterable<T> inputs) throws IOException {
        Compiler compiler = new Compiler();
        compiler.init(ImmutableList.of(), Lists.newArrayList(inputs), new CompilerOptions());
        ExtractMessagesVisitor extractCompilerPass = new ExtractMessagesVisitor(compiler);
        for (SourceFile input : inputs) {
            Node root = new JsAst(input).getAstRoot(compiler);
            extractCompilerPass.process(null, root);
        }
        JSError[] errors = compiler.getErrors();
        if (errors.length > 0) {
            StringBuilder msg = new StringBuilder("JSCompiler errors\n");
            LightweightMessageFormatter formatter = new LightweightMessageFormatter(compiler);
            for (JSError e : errors) {
                msg.append(formatter.formatError(e));
            }
            throw new RuntimeException(msg.toString());
        }
        return extractCompilerPass.getMessages();
    }

    private class ExtractMessagesVisitor
    extends JsMessageVisitor {
        private final List<JsMessage> messages;

        private ExtractMessagesVisitor(AbstractCompiler compiler) {
            super(compiler, true, JsMessageExtractor.this.style, JsMessageExtractor.this.idGenerator);
            this.messages = Lists.newLinkedList();
        }

        @Override
        protected void processJsMessage(JsMessage message, JsMessageDefinition definition) {
            if (!message.isExternal()) {
                this.messages.add(message);
            }
        }

        public Collection<JsMessage> getMessages() {
            return this.messages;
        }
    }
}

