/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;

class PrepareAst
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final boolean checkOnly;

    PrepareAst(AbstractCompiler compiler) {
        this(compiler, false);
    }

    PrepareAst(AbstractCompiler compiler, boolean checkOnly) {
        this.compiler = compiler;
        this.checkOnly = checkOnly;
    }

    private void reportChange() {
        if (this.checkOnly) {
            Preconditions.checkState((boolean)false, (Object)"normalizeNodeType constraints violated");
        }
    }

    @Override
    public void process(Node externs, Node root) {
        if (this.checkOnly) {
            this.normalizeNodeTypes(root);
        } else {
            if (externs != null) {
                NodeTraversal.traverse(this.compiler, externs, new PrepareAnnotations(this.compiler));
            }
            if (root != null) {
                NodeTraversal.traverse(this.compiler, root, new PrepareAnnotations(this.compiler));
            }
        }
    }

    private void normalizeNodeTypes(Node n) {
        this.normalizeBlocks(n);
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            Preconditions.checkState((child.getParent() == n ? 1 : 0) != 0);
            this.normalizeNodeTypes(child);
        }
    }

    private void normalizeBlocks(Node n) {
        if (NodeUtil.isControlStructure(n) && !n.isLabel() && !n.isSwitch()) {
            for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                if (!NodeUtil.isControlStructureCodeBlock(n, c) || c.isBlock()) continue;
                Node newBlock = IR.block().srcref(n);
                n.replaceChild(c, newBlock);
                if (!c.isEmpty()) {
                    newBlock.addChildrenToFront(c);
                } else {
                    newBlock.setWasEmptyNode(true);
                }
                c = newBlock;
                this.reportChange();
            }
        }
    }

    static class PrepareAnnotations
    implements NodeTraversal.Callback {
        private final CodingConvention convention;

        PrepareAnnotations(AbstractCompiler compiler) {
            this.convention = compiler.getCodingConvention();
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (n.isObjectLit()) {
                this.normalizeObjectLiteralAnnotations(n);
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 37: {
                    this.annotateCalls(n);
                    break;
                }
                case 105: {
                    this.annotateFunctions(n, parent);
                    this.annotateDispatchers(n, parent);
                }
            }
        }

        private void normalizeObjectLiteralAnnotations(Node objlit) {
            Preconditions.checkState((boolean)objlit.isObjectLit());
            for (Node key = objlit.getFirstChild(); key != null; key = key.getNext()) {
                Node value = key.getFirstChild();
                this.normalizeObjectLiteralKeyAnnotations(objlit, key, value);
            }
        }

        private void annotateCalls(Node n) {
            Preconditions.checkState((boolean)n.isCall());
            Node first = n.getFirstChild();
            if (!NodeUtil.isGet(first)) {
                n.putBooleanProp(50, true);
            }
            if (first.isName() && "eval".equals(first.getString())) {
                first.putBooleanProp(49, true);
            }
        }

        private void annotateDispatchers(Node n, Node parent) {
            Preconditions.checkState((boolean)n.isFunction());
            if (parent.getJSDocInfo() != null && parent.getJSDocInfo().isJavaDispatch() && parent.isAssign()) {
                Preconditions.checkState((parent.getLastChild() == n ? 1 : 0) != 0);
                n.putBooleanProp(47, true);
            }
        }

        private void normalizeObjectLiteralKeyAnnotations(Node objlit, Node key, Node value) {
            Preconditions.checkState((boolean)objlit.isObjectLit());
            if (key.getJSDocInfo() != null && value.isFunction()) {
                value.setJSDocInfo(key.getJSDocInfo());
            }
        }

        private void annotateFunctions(Node n, Node parent) {
            JSDocInfo fnInfo = NodeUtil.getFunctionJSDocInfo(n);
            Node args = n.getFirstChild().getNext();
            for (Node arg = args.getFirstChild(); arg != null; arg = arg.getNext()) {
                JSTypeExpression typeExpr;
                String argName = arg.getString();
                JSTypeExpression jSTypeExpression = typeExpr = fnInfo == null ? null : fnInfo.getParameterType(argName);
                if (this.convention.isOptionalParameter(arg) || typeExpr != null && typeExpr.isOptionalArg()) {
                    arg.putBooleanProp(44, true);
                }
                if (!this.convention.isVarArgsParameter(arg) && (typeExpr == null || !typeExpr.isVarArgs())) continue;
                arg.putBooleanProp(45, true);
            }
        }
    }
}

