/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.ScriptRuntime;
import com.google.javascript.rhino.jstype.AllType;
import com.google.javascript.rhino.jstype.ArrowType;
import com.google.javascript.rhino.jstype.BooleanType;
import com.google.javascript.rhino.jstype.EnumType;
import com.google.javascript.rhino.jstype.ErrorFunctionType;
import com.google.javascript.rhino.jstype.FunctionBuilder;
import com.google.javascript.rhino.jstype.FunctionParamBuilder;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.IndexedType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.NamedType;
import com.google.javascript.rhino.jstype.NoObjectType;
import com.google.javascript.rhino.jstype.NoResolvedType;
import com.google.javascript.rhino.jstype.NoType;
import com.google.javascript.rhino.jstype.NullType;
import com.google.javascript.rhino.jstype.NumberType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.ParameterizedType;
import com.google.javascript.rhino.jstype.PrototypeObjectType;
import com.google.javascript.rhino.jstype.RecordType;
import com.google.javascript.rhino.jstype.RecordTypeBuilder;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.StringType;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.UnionTypeBuilder;
import com.google.javascript.rhino.jstype.UnknownType;
import com.google.javascript.rhino.jstype.UnresolvedTypeExpression;
import com.google.javascript.rhino.jstype.VoidType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JSTypeRegistry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int PROPERTY_CHECKING_UNION_SIZE = 3000;
    private final transient ErrorReporter reporter;
    private final JSType[] nativeTypes;
    private final Map<String, JSType> namesToTypes;
    private final Set<String> namespaces = new HashSet<String>();
    private final Set<String> nonNullableTypeNames = new HashSet<String>();
    private final Set<String> forwardDeclaredTypes = new HashSet<String>();
    private final Map<String, UnionTypeBuilder> typesIndexedByProperty = Maps.newHashMap();
    private final Map<String, Map<String, ObjectType>> eachRefTypeIndexedByProperty = Maps.newHashMap();
    private final Map<String, JSType> greatestSubtypeByProperty = Maps.newHashMap();
    private final Multimap<String, FunctionType> interfaceToImplementors = LinkedHashMultimap.create();
    private final Multimap<StaticScope<JSType>, NamedType> unresolvedNamedTypes = ArrayListMultimap.create();
    private final Multimap<StaticScope<JSType>, NamedType> resolvedNamedTypes = ArrayListMultimap.create();
    private boolean lastGeneration = true;
    private Map<String, TemplateType> templateTypes = Maps.newHashMap();
    private final boolean tolerateUndefinedValues;
    private ResolveMode resolveMode = ResolveMode.LAZY_NAMES;

    public JSTypeRegistry(ErrorReporter reporter) {
        this(reporter, false);
    }

    public JSTypeRegistry(ErrorReporter reporter, boolean tolerateUndefinedValues) {
        this.reporter = reporter;
        this.nativeTypes = new JSType[JSTypeNative.values().length];
        this.namesToTypes = new HashMap<String, JSType>();
        this.resetForTypeCheck();
        this.tolerateUndefinedValues = tolerateUndefinedValues;
    }

    public void setResolveMode(ResolveMode mode) {
        this.resolveMode = mode;
    }

    ResolveMode getResolveMode() {
        return this.resolveMode;
    }

    public ErrorReporter getErrorReporter() {
        return this.reporter;
    }

    public boolean shouldTolerateUndefinedValues() {
        return this.tolerateUndefinedValues;
    }

    public void resetForTypeCheck() {
        this.typesIndexedByProperty.clear();
        this.eachRefTypeIndexedByProperty.clear();
        this.initializeBuiltInTypes();
        this.namesToTypes.clear();
        this.namespaces.clear();
        this.initializeRegistry();
    }

    private void initializeBuiltInTypes() {
        BooleanType BOOLEAN_TYPE = new BooleanType(this);
        this.registerNativeType(JSTypeNative.BOOLEAN_TYPE, BOOLEAN_TYPE);
        NullType NULL_TYPE = new NullType(this);
        this.registerNativeType(JSTypeNative.NULL_TYPE, NULL_TYPE);
        NumberType NUMBER_TYPE = new NumberType(this);
        this.registerNativeType(JSTypeNative.NUMBER_TYPE, NUMBER_TYPE);
        StringType STRING_TYPE = new StringType(this);
        this.registerNativeType(JSTypeNative.STRING_TYPE, STRING_TYPE);
        UnknownType UNKNOWN_TYPE = new UnknownType(this, false);
        this.registerNativeType(JSTypeNative.UNKNOWN_TYPE, UNKNOWN_TYPE);
        this.registerNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE, new UnknownType(this, true));
        VoidType VOID_TYPE = new VoidType(this);
        this.registerNativeType(JSTypeNative.VOID_TYPE, VOID_TYPE);
        AllType ALL_TYPE = new AllType(this);
        this.registerNativeType(JSTypeNative.ALL_TYPE, ALL_TYPE);
        PrototypeObjectType TOP_LEVEL_PROTOTYPE = new PrototypeObjectType(this, null, null, true);
        this.registerNativeType(JSTypeNative.TOP_LEVEL_PROTOTYPE, TOP_LEVEL_PROTOTYPE);
        FunctionType OBJECT_FUNCTION_TYPE = new FunctionType(this, "Object", null, this.createArrowType(this.createOptionalParameters(ALL_TYPE), UNKNOWN_TYPE), null, null, true, true);
        OBJECT_FUNCTION_TYPE.setPrototype(TOP_LEVEL_PROTOTYPE, null);
        this.registerNativeType(JSTypeNative.OBJECT_FUNCTION_TYPE, OBJECT_FUNCTION_TYPE);
        ObjectType OBJECT_TYPE = OBJECT_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.OBJECT_TYPE, OBJECT_TYPE);
        ObjectType OBJECT_PROTOTYPE = OBJECT_FUNCTION_TYPE.getPrototype();
        this.registerNativeType(JSTypeNative.OBJECT_PROTOTYPE, OBJECT_PROTOTYPE);
        FunctionType FUNCTION_FUNCTION_TYPE = new FunctionType(this, "Function", null, this.createArrowType(this.createParametersWithVarArgs(ALL_TYPE), UNKNOWN_TYPE), null, null, true, true);
        FUNCTION_FUNCTION_TYPE.setPrototypeBasedOn(OBJECT_TYPE);
        this.registerNativeType(JSTypeNative.FUNCTION_FUNCTION_TYPE, FUNCTION_FUNCTION_TYPE);
        ObjectType FUNCTION_PROTOTYPE = FUNCTION_FUNCTION_TYPE.getPrototype();
        this.registerNativeType(JSTypeNative.FUNCTION_PROTOTYPE, FUNCTION_PROTOTYPE);
        NoType NO_TYPE = new NoType(this);
        this.registerNativeType(JSTypeNative.NO_TYPE, NO_TYPE);
        NoObjectType NO_OBJECT_TYPE = new NoObjectType(this);
        this.registerNativeType(JSTypeNative.NO_OBJECT_TYPE, NO_OBJECT_TYPE);
        NoResolvedType NO_RESOLVED_TYPE = new NoResolvedType(this);
        this.registerNativeType(JSTypeNative.NO_RESOLVED_TYPE, NO_RESOLVED_TYPE);
        FunctionType ARRAY_FUNCTION_TYPE = new FunctionType(this, "Array", null, this.createArrowType(this.createParametersWithVarArgs(ALL_TYPE), null), null, null, true, true);
        ARRAY_FUNCTION_TYPE.getInternalArrowType().returnType = ARRAY_FUNCTION_TYPE.getInstanceType();
        ObjectType arrayPrototype = ARRAY_FUNCTION_TYPE.getPrototype();
        this.registerNativeType(JSTypeNative.ARRAY_FUNCTION_TYPE, ARRAY_FUNCTION_TYPE);
        ObjectType ARRAY_TYPE = ARRAY_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.ARRAY_TYPE, ARRAY_TYPE);
        FunctionType BOOLEAN_OBJECT_FUNCTION_TYPE = new FunctionType(this, "Boolean", null, this.createArrowType(this.createParameters(false, ALL_TYPE), BOOLEAN_TYPE), null, null, true, true);
        ObjectType booleanPrototype = BOOLEAN_OBJECT_FUNCTION_TYPE.getPrototype();
        this.registerNativeType(JSTypeNative.BOOLEAN_OBJECT_FUNCTION_TYPE, BOOLEAN_OBJECT_FUNCTION_TYPE);
        ObjectType BOOLEAN_OBJECT_TYPE = BOOLEAN_OBJECT_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.BOOLEAN_OBJECT_TYPE, BOOLEAN_OBJECT_TYPE);
        FunctionType DATE_FUNCTION_TYPE = new FunctionType(this, "Date", null, this.createArrowType(this.createOptionalParameters(UNKNOWN_TYPE, UNKNOWN_TYPE, UNKNOWN_TYPE, UNKNOWN_TYPE, UNKNOWN_TYPE, UNKNOWN_TYPE, UNKNOWN_TYPE), STRING_TYPE), null, null, true, true);
        ObjectType datePrototype = DATE_FUNCTION_TYPE.getPrototype();
        this.registerNativeType(JSTypeNative.DATE_FUNCTION_TYPE, DATE_FUNCTION_TYPE);
        ObjectType DATE_TYPE = DATE_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.DATE_TYPE, DATE_TYPE);
        ErrorFunctionType ERROR_FUNCTION_TYPE = new ErrorFunctionType(this, "Error");
        this.registerNativeType(JSTypeNative.ERROR_FUNCTION_TYPE, ERROR_FUNCTION_TYPE);
        ObjectType ERROR_TYPE = ERROR_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.ERROR_TYPE, ERROR_TYPE);
        ErrorFunctionType EVAL_ERROR_FUNCTION_TYPE = new ErrorFunctionType(this, "EvalError");
        EVAL_ERROR_FUNCTION_TYPE.setPrototypeBasedOn(ERROR_TYPE);
        this.registerNativeType(JSTypeNative.EVAL_ERROR_FUNCTION_TYPE, EVAL_ERROR_FUNCTION_TYPE);
        ObjectType EVAL_ERROR_TYPE = EVAL_ERROR_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.EVAL_ERROR_TYPE, EVAL_ERROR_TYPE);
        ErrorFunctionType RANGE_ERROR_FUNCTION_TYPE = new ErrorFunctionType(this, "RangeError");
        RANGE_ERROR_FUNCTION_TYPE.setPrototypeBasedOn(ERROR_TYPE);
        this.registerNativeType(JSTypeNative.RANGE_ERROR_FUNCTION_TYPE, RANGE_ERROR_FUNCTION_TYPE);
        ObjectType RANGE_ERROR_TYPE = RANGE_ERROR_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.RANGE_ERROR_TYPE, RANGE_ERROR_TYPE);
        ErrorFunctionType REFERENCE_ERROR_FUNCTION_TYPE = new ErrorFunctionType(this, "ReferenceError");
        REFERENCE_ERROR_FUNCTION_TYPE.setPrototypeBasedOn(ERROR_TYPE);
        this.registerNativeType(JSTypeNative.REFERENCE_ERROR_FUNCTION_TYPE, REFERENCE_ERROR_FUNCTION_TYPE);
        ObjectType REFERENCE_ERROR_TYPE = REFERENCE_ERROR_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.REFERENCE_ERROR_TYPE, REFERENCE_ERROR_TYPE);
        ErrorFunctionType SYNTAX_ERROR_FUNCTION_TYPE = new ErrorFunctionType(this, "SyntaxError");
        SYNTAX_ERROR_FUNCTION_TYPE.setPrototypeBasedOn(ERROR_TYPE);
        this.registerNativeType(JSTypeNative.SYNTAX_ERROR_FUNCTION_TYPE, SYNTAX_ERROR_FUNCTION_TYPE);
        ObjectType SYNTAX_ERROR_TYPE = SYNTAX_ERROR_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.SYNTAX_ERROR_TYPE, SYNTAX_ERROR_TYPE);
        ErrorFunctionType TYPE_ERROR_FUNCTION_TYPE = new ErrorFunctionType(this, "TypeError");
        TYPE_ERROR_FUNCTION_TYPE.setPrototypeBasedOn(ERROR_TYPE);
        this.registerNativeType(JSTypeNative.TYPE_ERROR_FUNCTION_TYPE, TYPE_ERROR_FUNCTION_TYPE);
        ObjectType TYPE_ERROR_TYPE = TYPE_ERROR_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.TYPE_ERROR_TYPE, TYPE_ERROR_TYPE);
        ErrorFunctionType URI_ERROR_FUNCTION_TYPE = new ErrorFunctionType(this, "URIError");
        URI_ERROR_FUNCTION_TYPE.setPrototypeBasedOn(ERROR_TYPE);
        this.registerNativeType(JSTypeNative.URI_ERROR_FUNCTION_TYPE, URI_ERROR_FUNCTION_TYPE);
        ObjectType URI_ERROR_TYPE = URI_ERROR_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.URI_ERROR_TYPE, URI_ERROR_TYPE);
        FunctionType NUMBER_OBJECT_FUNCTION_TYPE = new FunctionType(this, "Number", null, this.createArrowType(this.createParameters(false, ALL_TYPE), NUMBER_TYPE), null, null, true, true);
        ObjectType numberPrototype = NUMBER_OBJECT_FUNCTION_TYPE.getPrototype();
        this.registerNativeType(JSTypeNative.NUMBER_OBJECT_FUNCTION_TYPE, NUMBER_OBJECT_FUNCTION_TYPE);
        ObjectType NUMBER_OBJECT_TYPE = NUMBER_OBJECT_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.NUMBER_OBJECT_TYPE, NUMBER_OBJECT_TYPE);
        FunctionType REGEXP_FUNCTION_TYPE = new FunctionType(this, "RegExp", null, this.createArrowType(this.createOptionalParameters(ALL_TYPE, ALL_TYPE)), null, null, true, true);
        REGEXP_FUNCTION_TYPE.getInternalArrowType().returnType = REGEXP_FUNCTION_TYPE.getInstanceType();
        ObjectType regexpPrototype = REGEXP_FUNCTION_TYPE.getPrototype();
        this.registerNativeType(JSTypeNative.REGEXP_FUNCTION_TYPE, REGEXP_FUNCTION_TYPE);
        ObjectType REGEXP_TYPE = REGEXP_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.REGEXP_TYPE, REGEXP_TYPE);
        FunctionType STRING_OBJECT_FUNCTION_TYPE = new FunctionType(this, "String", null, this.createArrowType(this.createParameters(false, ALL_TYPE), STRING_TYPE), null, null, true, true);
        ObjectType stringPrototype = STRING_OBJECT_FUNCTION_TYPE.getPrototype();
        this.registerNativeType(JSTypeNative.STRING_OBJECT_FUNCTION_TYPE, STRING_OBJECT_FUNCTION_TYPE);
        ObjectType STRING_OBJECT_TYPE = STRING_OBJECT_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.STRING_OBJECT_TYPE, STRING_OBJECT_TYPE);
        JSType NULL_VOID = this.createUnionType(NULL_TYPE, VOID_TYPE);
        this.registerNativeType(JSTypeNative.NULL_VOID, NULL_VOID);
        JSType OBJECT_NUMBER_STRING = this.createUnionType(OBJECT_TYPE, NUMBER_TYPE, STRING_TYPE);
        this.registerNativeType(JSTypeNative.OBJECT_NUMBER_STRING, OBJECT_NUMBER_STRING);
        JSType OBJECT_NUMBER_STRING_BOOLEAN = this.createUnionType(OBJECT_TYPE, NUMBER_TYPE, STRING_TYPE, BOOLEAN_TYPE);
        this.registerNativeType(JSTypeNative.OBJECT_NUMBER_STRING_BOOLEAN, OBJECT_NUMBER_STRING_BOOLEAN);
        JSType NUMBER_STRING_BOOLEAN = this.createUnionType(NUMBER_TYPE, STRING_TYPE, BOOLEAN_TYPE);
        this.registerNativeType(JSTypeNative.NUMBER_STRING_BOOLEAN, NUMBER_STRING_BOOLEAN);
        JSType NUMBER_STRING = this.createUnionType(NUMBER_TYPE, STRING_TYPE);
        this.registerNativeType(JSTypeNative.NUMBER_STRING, NUMBER_STRING);
        JSType STRING_VALUE_OR_OBJECT_TYPE = this.createUnionType(STRING_OBJECT_TYPE, STRING_TYPE);
        this.registerNativeType(JSTypeNative.STRING_VALUE_OR_OBJECT_TYPE, STRING_VALUE_OR_OBJECT_TYPE);
        JSType NUMBER_VALUE_OR_OBJECT_TYPE = this.createUnionType(NUMBER_OBJECT_TYPE, NUMBER_TYPE);
        this.registerNativeType(JSTypeNative.NUMBER_VALUE_OR_OBJECT_TYPE, NUMBER_VALUE_OR_OBJECT_TYPE);
        FunctionType U2U_FUNCTION_TYPE = this.createFunctionType((JSType)UNKNOWN_TYPE, true, UNKNOWN_TYPE);
        this.registerNativeType(JSTypeNative.U2U_FUNCTION_TYPE, U2U_FUNCTION_TYPE);
        FunctionType U2U_CONSTRUCTOR_TYPE = new FunctionType(this, "Function", null, this.createArrowType(this.createParametersWithVarArgs(UNKNOWN_TYPE), UNKNOWN_TYPE), NO_OBJECT_TYPE, null, true, true){
            private static final long serialVersionUID = 1L;

            @Override
            public FunctionType getConstructor() {
                return this.registry.getNativeFunctionType(JSTypeNative.FUNCTION_FUNCTION_TYPE);
            }
        };
        this.registerNativeType(JSTypeNative.U2U_CONSTRUCTOR_TYPE, U2U_CONSTRUCTOR_TYPE);
        this.registerNativeType(JSTypeNative.FUNCTION_INSTANCE_TYPE, U2U_CONSTRUCTOR_TYPE);
        FUNCTION_FUNCTION_TYPE.setInstanceType(U2U_CONSTRUCTOR_TYPE);
        U2U_CONSTRUCTOR_TYPE.setImplicitPrototype(FUNCTION_PROTOTYPE);
        FunctionType LEAST_FUNCTION_TYPE = this.createNativeFunctionTypeWithVarArgs(NO_TYPE, ALL_TYPE);
        this.registerNativeType(JSTypeNative.LEAST_FUNCTION_TYPE, LEAST_FUNCTION_TYPE);
        FunctionType GLOBAL_THIS_CTOR = new FunctionType(this, "global this", null, this.createArrowType(this.createParameters(false, ALL_TYPE), NUMBER_TYPE), null, null, true, true);
        ObjectType GLOBAL_THIS = GLOBAL_THIS_CTOR.getInstanceType();
        this.registerNativeType(JSTypeNative.GLOBAL_THIS, GLOBAL_THIS);
        FunctionType GREATEST_FUNCTION_TYPE = this.createNativeFunctionTypeWithVarArgs(ALL_TYPE, NO_TYPE);
        this.registerNativeType(JSTypeNative.GREATEST_FUNCTION_TYPE, GREATEST_FUNCTION_TYPE);
        this.registerPropertyOnType("prototype", OBJECT_FUNCTION_TYPE);
    }

    private void initializeRegistry() {
        this.register(this.getNativeType(JSTypeNative.ARRAY_TYPE));
        this.register(this.getNativeType(JSTypeNative.BOOLEAN_OBJECT_TYPE));
        this.register(this.getNativeType(JSTypeNative.BOOLEAN_TYPE));
        this.register(this.getNativeType(JSTypeNative.DATE_TYPE));
        this.register(this.getNativeType(JSTypeNative.NULL_TYPE));
        this.register(this.getNativeType(JSTypeNative.NULL_TYPE), "Null");
        this.register(this.getNativeType(JSTypeNative.NUMBER_OBJECT_TYPE));
        this.register(this.getNativeType(JSTypeNative.NUMBER_TYPE));
        this.register(this.getNativeType(JSTypeNative.OBJECT_TYPE));
        this.register(this.getNativeType(JSTypeNative.ERROR_TYPE));
        this.register(this.getNativeType(JSTypeNative.URI_ERROR_TYPE));
        this.register(this.getNativeType(JSTypeNative.EVAL_ERROR_TYPE));
        this.register(this.getNativeType(JSTypeNative.TYPE_ERROR_TYPE));
        this.register(this.getNativeType(JSTypeNative.RANGE_ERROR_TYPE));
        this.register(this.getNativeType(JSTypeNative.REFERENCE_ERROR_TYPE));
        this.register(this.getNativeType(JSTypeNative.SYNTAX_ERROR_TYPE));
        this.register(this.getNativeType(JSTypeNative.REGEXP_TYPE));
        this.register(this.getNativeType(JSTypeNative.STRING_OBJECT_TYPE));
        this.register(this.getNativeType(JSTypeNative.STRING_TYPE));
        this.register(this.getNativeType(JSTypeNative.VOID_TYPE));
        this.register(this.getNativeType(JSTypeNative.VOID_TYPE), "Undefined");
        this.register(this.getNativeType(JSTypeNative.VOID_TYPE), "void");
        this.register(this.getNativeType(JSTypeNative.FUNCTION_INSTANCE_TYPE), "Function");
    }

    private void register(JSType type) {
        this.register(type, type.toString());
    }

    private void register(JSType type, String name) {
        this.namesToTypes.put(name, type);
        while (name.indexOf(46) > 0) {
            name = name.substring(0, name.lastIndexOf(46));
            this.namespaces.add(name);
        }
    }

    private void registerNativeType(JSTypeNative typeId, JSType type) {
        this.nativeTypes[typeId.ordinal()] = type;
    }

    public void registerPropertyOnType(String propertyName, JSType type) {
        UnionTypeBuilder typeSet = this.typesIndexedByProperty.get(propertyName);
        if (typeSet == null) {
            typeSet = new UnionTypeBuilder(this, 3000);
            this.typesIndexedByProperty.put(propertyName, typeSet);
        }
        typeSet.addAlternate(type);
        this.addReferenceTypeIndexedByProperty(propertyName, type);
        this.greatestSubtypeByProperty.remove(propertyName);
    }

    private void addReferenceTypeIndexedByProperty(String propertyName, JSType type) {
        if (type instanceof ObjectType && ((ObjectType)type).hasReferenceName()) {
            HashMap typeSet = this.eachRefTypeIndexedByProperty.get(propertyName);
            if (typeSet == null) {
                typeSet = Maps.newHashMap();
                this.eachRefTypeIndexedByProperty.put(propertyName, typeSet);
            }
            ObjectType objType = (ObjectType)type;
            typeSet.put(objType.getReferenceName(), objType);
        } else if (type instanceof NamedType) {
            this.addReferenceTypeIndexedByProperty(propertyName, ((NamedType)type).getReferencedType());
        } else if (type.isUnionType()) {
            for (JSType alternate : type.toMaybeUnionType().getAlternates()) {
                this.addReferenceTypeIndexedByProperty(propertyName, alternate);
            }
        }
    }

    public void unregisterPropertyOnType(String propertyName, JSType type) {
        Map<String, ObjectType> typeSet = this.eachRefTypeIndexedByProperty.get(propertyName);
        if (typeSet != null) {
            typeSet.remove(type.toObjectType().getReferenceName());
        }
    }

    public JSType getGreatestSubtypeWithProperty(JSType type, String propertyName) {
        if (this.greatestSubtypeByProperty.containsKey(propertyName)) {
            return this.greatestSubtypeByProperty.get(propertyName).getGreatestSubtype(type);
        }
        if (this.typesIndexedByProperty.containsKey(propertyName)) {
            JSType built = this.typesIndexedByProperty.get(propertyName).build();
            this.greatestSubtypeByProperty.put(propertyName, built);
            return built.getGreatestSubtype(type);
        }
        return this.getNativeType(JSTypeNative.NO_TYPE);
    }

    public boolean canPropertyBeDefined(JSType type, String propertyName) {
        if (this.typesIndexedByProperty.containsKey(propertyName)) {
            for (JSType alt : this.typesIndexedByProperty.get(propertyName).getAlternates()) {
                RecordType maybeRecordType;
                JSType greatestSubtype = alt.getGreatestSubtype(type);
                if (greatestSubtype.isEmptyType() || (maybeRecordType = greatestSubtype.toMaybeRecordType()) != null && maybeRecordType.isSynthetic()) continue;
                return true;
            }
        }
        return false;
    }

    public Iterable<JSType> getTypesWithProperty(String propertyName) {
        if (this.typesIndexedByProperty.containsKey(propertyName)) {
            return this.typesIndexedByProperty.get(propertyName).getAlternates();
        }
        return ImmutableList.of();
    }

    public Iterable<ObjectType> getEachReferenceTypeWithProperty(String propertyName) {
        if (this.eachRefTypeIndexedByProperty.containsKey(propertyName)) {
            return this.eachRefTypeIndexedByProperty.get(propertyName).values();
        }
        return ImmutableList.of();
    }

    ObjectType findCommonSuperObject(ObjectType a, ObjectType b) {
        List<ObjectType> stackA = JSTypeRegistry.getSuperStack(a);
        List<ObjectType> stackB = JSTypeRegistry.getSuperStack(b);
        ObjectType result = this.getNativeObjectType(JSTypeNative.OBJECT_TYPE);
        while (!stackA.isEmpty() && !stackB.isEmpty()) {
            ObjectType currentB;
            ObjectType currentA = stackA.remove(stackA.size() - 1);
            if (currentA.isEquivalentTo(currentB = stackB.remove(stackB.size() - 1))) {
                result = currentA;
                continue;
            }
            return result;
        }
        return result;
    }

    private static List<ObjectType> getSuperStack(ObjectType a) {
        ArrayList stack = Lists.newArrayListWithExpectedSize((int)5);
        for (ObjectType current = a; current != null; current = current.getImplicitPrototype()) {
            stack.add(current);
        }
        return stack;
    }

    public void incrementGeneration() {
        for (NamedType type : this.resolvedNamedTypes.values()) {
            type.clearResolved();
        }
        this.unresolvedNamedTypes.putAll(this.resolvedNamedTypes);
        this.resolvedNamedTypes.clear();
    }

    boolean isLastGeneration() {
        return this.lastGeneration;
    }

    public void setLastGeneration(boolean lastGeneration) {
        this.lastGeneration = lastGeneration;
    }

    void registerTypeImplementingInterface(FunctionType type, ObjectType interfaceInstance) {
        this.interfaceToImplementors.put((Object)interfaceInstance.getReferenceName(), (Object)type);
    }

    public Collection<FunctionType> getDirectImplementors(ObjectType interfaceInstance) {
        return this.interfaceToImplementors.get((Object)interfaceInstance.getReferenceName());
    }

    public boolean declareType(String name, JSType t) {
        if (this.namesToTypes.containsKey(name)) {
            return false;
        }
        this.register(t, name);
        return true;
    }

    public void overwriteDeclaredType(String name, JSType t) {
        Preconditions.checkState((boolean)this.namesToTypes.containsKey(name));
        this.register(t, name);
    }

    public void forwardDeclareType(String name) {
        this.forwardDeclaredTypes.add(name);
    }

    public boolean isForwardDeclaredType(String name) {
        return this.forwardDeclaredTypes.contains(name);
    }

    public boolean hasNamespace(String name) {
        return this.namespaces.contains(name);
    }

    public JSType getType(String jsTypeName) {
        TemplateType templateType = this.templateTypes.get(jsTypeName);
        if (templateType != null) {
            return templateType;
        }
        return this.namesToTypes.get(jsTypeName);
    }

    public JSType getNativeType(JSTypeNative typeId) {
        return this.nativeTypes[typeId.ordinal()];
    }

    public ObjectType getNativeObjectType(JSTypeNative typeId) {
        return (ObjectType)this.getNativeType(typeId);
    }

    public FunctionType getNativeFunctionType(JSTypeNative typeId) {
        return (FunctionType)this.getNativeType(typeId);
    }

    public JSType getType(StaticScope<JSType> scope, String jsTypeName, String sourceName, int lineno, int charno) {
        JSType type = this.getType(jsTypeName);
        if (type == null) {
            NamedType namedType = new NamedType(this, jsTypeName, sourceName, lineno, charno);
            this.unresolvedNamedTypes.put(scope, (Object)namedType);
            type = namedType;
        }
        return type;
    }

    public void clearNamedTypes() {
        this.resolvedNamedTypes.clear();
        this.unresolvedNamedTypes.clear();
    }

    public void resolveTypesInScope(StaticScope<JSType> scope) {
        for (NamedType type : this.unresolvedNamedTypes.get(scope)) {
            type.resolve(this.reporter, scope);
        }
        this.resolvedNamedTypes.putAll(scope, (Iterable)this.unresolvedNamedTypes.removeAll(scope));
        if (scope != null && scope.getParentScope() == null) {
            PrototypeObjectType globalThis = (PrototypeObjectType)this.getNativeType(JSTypeNative.GLOBAL_THIS);
            JSType windowType = this.getType("Window");
            if (globalThis.isUnknownType()) {
                ObjectType windowObjType = ObjectType.cast(windowType);
                if (windowObjType != null) {
                    globalThis.setImplicitPrototype(windowObjType);
                } else {
                    globalThis.setImplicitPrototype(this.getNativeObjectType(JSTypeNative.OBJECT_TYPE));
                }
            }
        }
    }

    public JSType createOptionalType(JSType type) {
        if (type instanceof UnknownType || type.isAllType()) {
            return type;
        }
        return this.createUnionType(type, this.getNativeType(JSTypeNative.VOID_TYPE));
    }

    public JSType createDefaultObjectUnion(JSType type) {
        if (type.isTemplateType()) {
            return type;
        }
        return this.shouldTolerateUndefinedValues() ? this.createOptionalNullableType(type) : this.createNullableType(type);
    }

    public JSType createNullableType(JSType type) {
        return this.createUnionType(type, this.getNativeType(JSTypeNative.NULL_TYPE));
    }

    public JSType createOptionalNullableType(JSType type) {
        return this.createUnionType(type, this.getNativeType(JSTypeNative.VOID_TYPE), this.getNativeType(JSTypeNative.NULL_TYPE));
    }

    public JSType createUnionType(JSType ... variants) {
        UnionTypeBuilder builder = new UnionTypeBuilder(this);
        for (JSType type : variants) {
            builder.addAlternate(type);
        }
        return builder.build();
    }

    public JSType createUnionType(JSTypeNative ... variants) {
        UnionTypeBuilder builder = new UnionTypeBuilder(this);
        for (JSTypeNative typeId : variants) {
            builder.addAlternate(this.getNativeType(typeId));
        }
        return builder.build();
    }

    public EnumType createEnumType(String name, Node source, JSType elementsType) {
        return new EnumType(this, name, source, elementsType);
    }

    ArrowType createArrowType(Node parametersNode, JSType returnType) {
        return new ArrowType(this, parametersNode, returnType);
    }

    ArrowType createArrowType(Node parametersNode) {
        return new ArrowType(this, parametersNode, null);
    }

    public FunctionType createFunctionType(JSType returnType, JSType ... parameterTypes) {
        return this.createFunctionType(returnType, this.createParameters(parameterTypes));
    }

    public FunctionType createFunctionTypeWithVarArgs(JSType returnType, List<JSType> parameterTypes) {
        return this.createFunctionType(returnType, this.createParametersWithVarArgs(parameterTypes));
    }

    public FunctionType createFunctionType(JSType returnType, List<JSType> parameterTypes) {
        return this.createFunctionType(returnType, this.createParameters(parameterTypes));
    }

    public FunctionType createFunctionTypeWithVarArgs(JSType returnType, JSType ... parameterTypes) {
        return this.createFunctionType(returnType, this.createParametersWithVarArgs(parameterTypes));
    }

    private FunctionType createNativeFunctionTypeWithVarArgs(JSType returnType, JSType ... parameterTypes) {
        return this.createNativeFunctionType(returnType, this.createParametersWithVarArgs(parameterTypes));
    }

    public FunctionType createConstructorType(JSType returnType, JSType ... parameterTypes) {
        return this.createConstructorType(null, null, this.createParameters(parameterTypes), returnType);
    }

    public FunctionType createConstructorTypeWithVarArgs(JSType returnType, JSType ... parameterTypes) {
        return this.createConstructorType(null, null, this.createParametersWithVarArgs(parameterTypes), returnType);
    }

    public JSType createFunctionType(ObjectType instanceType, JSType returnType, List<JSType> parameterTypes) {
        return new FunctionBuilder(this).withParamsNode(this.createParameters(parameterTypes)).withReturnType(returnType).withTypeOfThis(instanceType).build();
    }

    public JSType createFunctionTypeWithVarArgs(ObjectType instanceType, JSType returnType, List<JSType> parameterTypes) {
        return new FunctionBuilder(this).withParamsNode(this.createParametersWithVarArgs(parameterTypes)).withReturnType(returnType).withTypeOfThis(instanceType).build();
    }

    public Node createParameters(List<JSType> parameterTypes) {
        return this.createParameters(parameterTypes.toArray(new JSType[parameterTypes.size()]));
    }

    public Node createParametersWithVarArgs(List<JSType> parameterTypes) {
        return this.createParametersWithVarArgs(parameterTypes.toArray(new JSType[parameterTypes.size()]));
    }

    public Node createParameters(JSType ... parameterTypes) {
        return this.createParameters(false, parameterTypes);
    }

    public Node createParametersWithVarArgs(JSType ... parameterTypes) {
        return this.createParameters(true, parameterTypes);
    }

    public Node createOptionalParameters(JSType ... parameterTypes) {
        FunctionParamBuilder builder = new FunctionParamBuilder(this);
        builder.addOptionalParams(parameterTypes);
        return builder.build();
    }

    private Node createParameters(boolean lastVarArgs, JSType ... parameterTypes) {
        FunctionParamBuilder builder = new FunctionParamBuilder(this);
        int max = parameterTypes.length - 1;
        for (int i = 0; i <= max; ++i) {
            if (lastVarArgs && i == max) {
                builder.addVarArgs(parameterTypes[i]);
                continue;
            }
            builder.addRequiredParams(parameterTypes[i]);
        }
        return builder.build();
    }

    public FunctionType createFunctionType(JSType returnType, boolean lastVarArgs, JSType ... parameterTypes) {
        if (lastVarArgs) {
            return this.createFunctionTypeWithVarArgs(returnType, parameterTypes);
        }
        return this.createFunctionType(returnType, parameterTypes);
    }

    public FunctionType createFunctionTypeWithNewReturnType(FunctionType existingFunctionType, JSType returnType) {
        return new FunctionBuilder(this).copyFromOtherFunction(existingFunctionType).withReturnType(returnType).build();
    }

    public FunctionType createFunctionTypeWithNewThisType(FunctionType existingFunctionType, ObjectType thisType) {
        return new FunctionBuilder(this).copyFromOtherFunction(existingFunctionType).withTypeOfThis(thisType).build();
    }

    public FunctionType createFunctionType(JSType returnType, Node parameters) {
        return new FunctionBuilder(this).withParamsNode(parameters).withReturnType(returnType).build();
    }

    private FunctionType createNativeFunctionType(JSType returnType, Node parameters) {
        return new FunctionBuilder(this).withParamsNode(parameters).withReturnType(returnType).forNativeType().build();
    }

    public FunctionType createConstructorType(JSType returnType, boolean lastVarArgs, JSType ... parameterTypes) {
        if (lastVarArgs) {
            return this.createConstructorTypeWithVarArgs(returnType, parameterTypes);
        }
        return this.createConstructorType(returnType, parameterTypes);
    }

    public ObjectType createObjectType(ObjectType implicitPrototype) {
        return this.createObjectType(null, null, implicitPrototype);
    }

    public RecordType createRecordType(Map<String, RecordTypeBuilder.RecordProperty> properties) {
        return new RecordType(this, properties);
    }

    public ObjectType createObjectType(String name, Node n, ObjectType implicitPrototype) {
        return new PrototypeObjectType(this, name, implicitPrototype);
    }

    public ObjectType createAnonymousObjectType() {
        PrototypeObjectType type = new PrototypeObjectType(this, null, null);
        type.setPrettyPrint(true);
        return type;
    }

    public boolean resetImplicitPrototype(JSType type, ObjectType newImplicitProto) {
        if (type instanceof PrototypeObjectType) {
            PrototypeObjectType poType = (PrototypeObjectType)type;
            poType.clearCachedValues();
            poType.setImplicitPrototype(newImplicitProto);
            return true;
        }
        return false;
    }

    ObjectType createNativeAnonymousObjectType() {
        PrototypeObjectType type = new PrototypeObjectType(this, null, null, true);
        type.setPrettyPrint(true);
        return type;
    }

    public FunctionType createConstructorType(String name, Node source, Node parameters, JSType returnType) {
        return new FunctionType(this, name, source, this.createArrowType(parameters, returnType), null, null, true, false);
    }

    public FunctionType createInterfaceType(String name, Node source) {
        return FunctionType.forInterface(this, name, source);
    }

    public ParameterizedType createParameterizedType(ObjectType objectType, JSType parameterType) {
        return new ParameterizedType(this, objectType, parameterType);
    }

    @VisibleForTesting
    public JSType createNamedType(String reference, String sourceName, int lineno, int charno) {
        return new NamedType(this, reference, sourceName, lineno, charno);
    }

    public void identifyNonNullableName(String name) {
        Preconditions.checkNotNull((Object)name);
        this.nonNullableTypeNames.add(name);
    }

    public JSType createFromTypeNodes(Node n, String sourceName, StaticScope<JSType> scope) {
        boolean hasNames;
        if (this.resolveMode == ResolveMode.LAZY_EXPRESSIONS && (hasNames = this.hasTypeName(n))) {
            return new UnresolvedTypeExpression(this, n, sourceName);
        }
        return this.createFromTypeNodesInternal(n, sourceName, scope);
    }

    private boolean hasTypeName(Node n) {
        if (n.getType() == 40) {
            return true;
        }
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            if (!this.hasTypeName(child)) continue;
            return true;
        }
        return false;
    }

    private JSType createFromTypeNodesInternal(Node n, String sourceName, StaticScope<JSType> scope) {
        switch (n.getType()) {
            case 309: {
                return this.createRecordTypeFromNodes(n.getFirstChild(), sourceName, scope);
            }
            case 306: {
                return this.createFromTypeNodesInternal(n.getFirstChild(), sourceName, scope).restrictByNotNullOrUndefined();
            }
            case 304: {
                Node firstChild = n.getFirstChild();
                if (firstChild == null) {
                    return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
                }
                return this.createDefaultObjectUnion(this.createFromTypeNodesInternal(firstChild, sourceName, scope));
            }
            case 307: {
                return this.createOptionalType(this.createFromTypeNodesInternal(n.getFirstChild(), sourceName, scope));
            }
            case 305: {
                return this.createOptionalType(this.createFromTypeNodesInternal(n.getFirstChild(), sourceName, scope));
            }
            case 302: {
                return this.getNativeType(JSTypeNative.ALL_TYPE);
            }
            case 308: {
                return this.getNativeType(JSTypeNative.ARRAY_TYPE);
            }
            case 301: {
                UnionTypeBuilder builder = new UnionTypeBuilder(this);
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    builder.addAlternate(this.createFromTypeNodesInternal(child, sourceName, scope));
                }
                return builder.build();
            }
            case 124: {
                return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
            case 122: {
                return this.getNativeType(JSTypeNative.VOID_TYPE);
            }
            case 40: {
                JSType namedType = this.getType(scope, n.getString(), sourceName, n.getLineno(), n.getCharno());
                if (this.resolveMode != ResolveMode.LAZY_NAMES) {
                    namedType = namedType.resolveInternal(this.reporter, scope);
                }
                if (namedType instanceof ObjectType && !this.nonNullableTypeNames.contains(n.getString())) {
                    Node typeList = n.getFirstChild();
                    if (typeList != null && ("Array".equals(n.getString()) || "Object".equals(n.getString()))) {
                        JSType parameterType = this.createFromTypeNodesInternal(typeList.getLastChild(), sourceName, scope);
                        namedType = new ParameterizedType(this, (ObjectType)namedType, parameterType);
                        if (typeList.hasMoreThanOneChild()) {
                            JSType indexType = this.createFromTypeNodesInternal(typeList.getFirstChild(), sourceName, scope);
                            namedType = new IndexedType(this, (ObjectType)namedType, indexType);
                        }
                    }
                    return this.createDefaultObjectUnion(namedType);
                }
                return namedType;
            }
            case 105: {
                ObjectType thisType = null;
                boolean isConstructor = false;
                Node current = n.getFirstChild();
                if (current.getType() == 42 || current.getType() == 30) {
                    Node contextNode = current.getFirstChild();
                    thisType = ObjectType.cast(this.createFromTypeNodesInternal(contextNode, sourceName, scope).restrictByNotNullOrUndefined());
                    if (thisType == null) {
                        this.reporter.warning(ScriptRuntime.getMessage0(current.getType() == 42 ? "msg.jsdoc.function.thisnotobject" : "msg.jsdoc.function.newnotobject"), sourceName, contextNode.getLineno(), contextNode.getCharno());
                    }
                    isConstructor = current.getType() == 30;
                    current = current.getNext();
                }
                FunctionParamBuilder paramBuilder = new FunctionParamBuilder(this);
                if (current.getType() == 83) {
                    Node args = current.getFirstChild();
                    for (Node arg = current.getFirstChild(); arg != null; arg = arg.getNext()) {
                        if (arg.getType() == 305) {
                            if (arg.getChildCount() == 0) {
                                paramBuilder.addVarArgs(this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
                                continue;
                            }
                            paramBuilder.addVarArgs(this.createFromTypeNodesInternal(arg.getFirstChild(), sourceName, scope));
                            continue;
                        }
                        JSType type = this.createFromTypeNodesInternal(arg, sourceName, scope);
                        if (arg.getType() == 307) {
                            boolean addSuccess = paramBuilder.addOptionalParams(type);
                            if (addSuccess) continue;
                            this.reporter.warning(ScriptRuntime.getMessage0("msg.jsdoc.function.varargs"), sourceName, arg.getLineno(), arg.getCharno());
                            continue;
                        }
                        paramBuilder.addRequiredParams(type);
                    }
                    current = current.getNext();
                }
                JSType returnType = this.createFromTypeNodesInternal(current, sourceName, scope);
                return new FunctionBuilder(this).withParams(paramBuilder).withReturnType(returnType).withTypeOfThis(thisType).setIsConstructor(isConstructor).build();
            }
        }
        throw new IllegalStateException("Unexpected node in type expression: " + n.toString());
    }

    private JSType createRecordTypeFromNodes(Node n, String sourceName, StaticScope<JSType> scope) {
        RecordTypeBuilder builder = new RecordTypeBuilder(this);
        for (Node fieldTypeNode = n.getFirstChild(); fieldTypeNode != null; fieldTypeNode = fieldTypeNode.getNext()) {
            String fieldName;
            Node fieldNameNode = fieldTypeNode;
            boolean hasType = false;
            if (fieldTypeNode.getType() == 310) {
                fieldNameNode = fieldTypeNode.getFirstChild();
                hasType = true;
            }
            if ((fieldName = fieldNameNode.getString()).startsWith("'") || fieldName.startsWith("\"")) {
                fieldName = fieldName.substring(1, fieldName.length() - 1);
            }
            JSType fieldType = null;
            fieldType = hasType ? this.createFromTypeNodesInternal(fieldTypeNode.getLastChild(), sourceName, scope) : this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            if (builder.addProperty(fieldName, fieldType, fieldNameNode) != null) continue;
            this.reporter.warning("Duplicate record field " + fieldName, sourceName, n.getLineno(), fieldNameNode.getCharno());
        }
        return builder.build();
    }

    public void setTemplateTypeNames(List<String> names) {
        Preconditions.checkNotNull(names);
        for (String name : names) {
            this.templateTypes.put(name, new TemplateType(this, name));
        }
    }

    public void clearTemplateTypeNames() {
        this.templateTypes.clear();
    }

    public static enum ResolveMode {
        LAZY_EXPRESSIONS,
        LAZY_NAMES,
        IMMEDIATE;

    }
}

