/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.http;

import java.util.Collections;
import java.util.List;
import javax.ws.rs.ext.RuntimeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceptEncoding {
    private static final RuntimeDelegate.HeaderDelegate<AcceptEncoding> delegate = RuntimeDelegate.getInstance().createHeaderDelegate(AcceptEncoding.class);
    private final String acceptEncodingHeader;
    private final boolean anyAllowed;
    private final List<String> acceptable;
    private final List<String> banned;
    private final List<ValuedEncoding> valuedEncodings;

    public AcceptEncoding(String acceptEncodingValue, List<String> acceptableEncodings, List<String> bannedEncodings, boolean anyEncodingAllowed, List<ValuedEncoding> encodings) {
        this.acceptEncodingHeader = acceptEncodingValue;
        this.anyAllowed = anyEncodingAllowed;
        this.acceptable = Collections.unmodifiableList(acceptableEncodings);
        this.banned = Collections.unmodifiableList(bannedEncodings);
        this.valuedEncodings = Collections.unmodifiableList(encodings);
    }

    public List<String> getAcceptableEncodings() {
        return this.acceptable;
    }

    public boolean isAnyEncodingAllowed() {
        return this.anyAllowed;
    }

    public List<String> getBannedEncodings() {
        return this.banned;
    }

    public static AcceptEncoding valueOf(String value) throws IllegalArgumentException {
        return (AcceptEncoding)delegate.fromString(value);
    }

    public String getAcceptEncodingHeader() {
        return this.acceptEncodingHeader;
    }

    public List<ValuedEncoding> getValuedEncodings() {
        return this.valuedEncodings;
    }

    public String toString() {
        return delegate.toString((Object)this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ValuedEncoding
    implements Comparable<ValuedEncoding> {
        public final double qValue;
        public final String encoding;

        public ValuedEncoding(double qValue, String encoding) {
            this.qValue = qValue;
            this.encoding = encoding;
        }

        @Override
        public int compareTo(ValuedEncoding other) {
            return Double.compare(this.qValue, other.qValue);
        }

        public boolean isWildcard() {
            return this.encoding == null;
        }

        public String toString() {
            return "ValuedEncoding(" + this.qValue + "," + this.encoding + ")";
        }
    }
}

