/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.providers.header;

import javax.ws.rs.core.EntityTag;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.wink.common.internal.i18n.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityTagHeaderDelegate
implements RuntimeDelegate.HeaderDelegate<EntityTag> {
    private static String WEAK = "W/";

    public EntityTag fromString(String eTag) throws IllegalArgumentException {
        if (eTag == null) {
            throw new IllegalArgumentException(Messages.getMessage("variableIsNull", "eTag"));
        }
        eTag = eTag.trim();
        boolean weak = false;
        if (eTag.startsWith(WEAK)) {
            eTag = eTag.substring(WEAK.length());
            weak = true;
        }
        if (!eTag.startsWith("\"") || !eTag.endsWith("\"")) {
            if ("*".equals(eTag)) {
                return new EntityTag("*");
            }
            throw new IllegalArgumentException(Messages.getMessage("entityTagNotQuoted", eTag));
        }
        eTag = eTag.substring(1, eTag.length() - 1);
        StringBuilder builder = null;
        for (int i = 0; i < eTag.length(); ++i) {
            if (eTag.charAt(i) == '\\' && i + 1 < eTag.length()) {
                if (builder != null) continue;
                builder = new StringBuilder(eTag.length());
                builder.append(eTag, 0, i);
                continue;
            }
            if (builder == null) continue;
            builder.append(eTag.charAt(i));
        }
        if (builder != null) {
            eTag = builder.toString();
        }
        return new EntityTag(eTag, weak);
    }

    public String toString(EntityTag eTag) {
        if (eTag == null) {
            throw new IllegalArgumentException(Messages.getMessage("variableIsNull", "eTag"));
        }
        StringBuilder builder = new StringBuilder();
        if (eTag.isWeak()) {
            builder.append("W/");
        }
        builder.append('\"');
        String value = eTag.getValue();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\"') {
                builder.append('\\');
            }
            builder.append(c);
        }
        builder.append('\"');
        return builder.toString();
    }
}

