/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.driver.textui;

import com.sun.msv.driver.textui.Debug;
import com.sun.msv.driver.textui.DebugController;
import com.sun.msv.driver.textui.ReportErrorHandler;
import com.sun.msv.grammar.Grammar;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.relax.RELAXModule;
import com.sun.msv.grammar.trex.TREXGrammar;
import com.sun.msv.grammar.util.ExpressionPrinter;
import com.sun.msv.grammar.xmlschema.ElementDeclExp;
import com.sun.msv.grammar.xmlschema.XMLSchemaGrammar;
import com.sun.msv.grammar.xmlschema.XMLSchemaSchema;
import com.sun.msv.reader.util.GrammarLoader;
import com.sun.msv.relaxns.grammar.RELAXGrammar;
import com.sun.msv.relaxns.verifier.SchemaProviderImpl;
import com.sun.msv.util.Util;
import com.sun.msv.verifier.DocumentDeclaration;
import com.sun.msv.verifier.ValidationUnrecoverableException;
import com.sun.msv.verifier.Verifier;
import com.sun.msv.verifier.identity.IDConstraintChecker;
import com.sun.msv.verifier.regexp.REDocumentDeclaration;
import com.sun.resolver.tools.CatalogResolver;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.iso_relax.dispatcher.SchemaProvider;
import org.iso_relax.dispatcher.impl.DispatcherImpl;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class Driver {
    static SAXParserFactory factory;
    public static final String MSG_DTDVALIDATION = "Driver.DTDValidation";
    public static final String MSG_PARSER = "Driver.Parser";
    public static final String MSG_USAGE = "Driver.Usage";
    public static final String MSG_UNRECOGNIZED_OPTION = "Driver.UnrecognizedOption";
    public static final String MSG_START_PARSING_GRAMMAR = "Driver.StartParsingGrammar";
    public static final String MSG_PARSING_TIME = "Driver.ParsingTime";
    public static final String MSG_VALIDATING = "Driver.Validating";
    public static final String MSG_VALIDATION_TIME = "Driver.ValidationTime";
    public static final String MSG_VALID = "Driver.Valid";
    public static final String MSG_INVALID = "Driver.Invalid";
    public static final String ERR_LOAD_GRAMMAR = "Driver.ErrLoadGrammar";
    public static final String MSG_BAILOUT = "Driver.BailOut";
    public static final String MSG_FAILED_TO_IGNORE_EXTERNAL_DTD = "Driver.FailedToIgnoreExternalDTD";
    public static final String MSG_WARNING_FOUND = "Driver.WarningFound";

    private static void usage() {
        System.out.println(Driver.localize(MSG_USAGE));
    }

    private static void printVersion() {
        System.out.println("Multi Schema Validator Ver." + ResourceBundle.getBundle("version").getString("version"));
    }

    public static void main(String[] stringArray) throws Exception {
        System.exit(Driver.run(stringArray));
    }

    public static int run(String[] stringArray) throws Exception {
        Vector<String> vector = new Vector<String>();
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = true;
        CatalogResolver catalogResolver = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase("-h") || stringArray[n].equalsIgnoreCase("-help") || stringArray[n].equalsIgnoreCase("-?")) {
                Driver.usage();
                return -1;
            }
            if (stringArray[n].equalsIgnoreCase("-strict")) {
                bl5 = true;
            } else if (stringArray[n].equalsIgnoreCase("-standalone")) {
                bl4 = true;
            } else if (stringArray[n].equalsIgnoreCase("-loose")) {
                bl4 = true;
            } else if (!stringArray[n].equalsIgnoreCase("-dtd")) {
                if (stringArray[n].equalsIgnoreCase("-dump")) {
                    bl = true;
                } else if (stringArray[n].equalsIgnoreCase("-debug")) {
                    Debug.debug = true;
                } else if (stringArray[n].equalsIgnoreCase("-xerces")) {
                    factory = (SAXParserFactory)Class.forName("org.apache.xerces.jaxp.SAXParserFactoryImpl").newInstance();
                } else if (stringArray[n].equalsIgnoreCase("-crimson")) {
                    factory = (SAXParserFactory)Class.forName("org.apache.crimson.jaxp.SAXParserFactoryImpl").newInstance();
                } else if (stringArray[n].equalsIgnoreCase("-oraclev2")) {
                    factory = (SAXParserFactory)Class.forName("oracle.xml.jaxp.JXSAXParserFactory").newInstance();
                } else if (stringArray[n].equalsIgnoreCase("-verbose")) {
                    bl2 = true;
                } else if (stringArray[n].equalsIgnoreCase("-warning")) {
                    bl3 = true;
                } else if (stringArray[n].equalsIgnoreCase("-maxerror")) {
                    bl6 = false;
                } else if (stringArray[n].equalsIgnoreCase("-locale")) {
                    String string2;
                    int n2;
                    if ((n2 = (string2 = stringArray[++n]).indexOf(45)) < 0) {
                        n2 = string2.indexOf(95);
                    }
                    if (n2 < 0) {
                        Locale.setDefault(new Locale(string2, ""));
                    } else {
                        Locale.setDefault(new Locale(string2.substring(0, n2), string2.substring(n2 + 1)));
                    }
                } else if (stringArray[n].equalsIgnoreCase("-catalog")) {
                    if (catalogResolver != null) {
                        catalogResolver = new CatalogResolver(true);
                    }
                    ((CatalogResolver)catalogResolver).getCatalog().parseCatalog(stringArray[++n]);
                } else {
                    if (stringArray[n].equalsIgnoreCase("-version")) {
                        Driver.printVersion();
                        return 0;
                    }
                    if (stringArray[n].charAt(0) == '-') {
                        System.err.println(Driver.localize(MSG_UNRECOGNIZED_OPTION, stringArray[n]));
                        Driver.usage();
                        return -1;
                    }
                    if (string == null) {
                        string = stringArray[n];
                    } else {
                        vector.add(stringArray[n]);
                    }
                }
            }
            ++n;
        }
        if (string == null) {
            System.out.println(Driver.localize(MSG_USAGE));
            return -1;
        }
        if (bl2) {
            Driver.printVersion();
        }
        if (factory == null) {
            factory = SAXParserFactory.newInstance();
        }
        if (bl2) {
            System.out.println(Driver.localize(MSG_PARSER, factory.getClass().getName()));
        }
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        if (!bl4 && bl2) {
            System.out.println(Driver.localize(MSG_DTDVALIDATION));
        }
        if (bl4) {
            try {
                factory.setFeature("http://xml.org/sax/features/validation", false);
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (Exception exception) {
                System.out.println(Driver.localize(MSG_FAILED_TO_IGNORE_EXTERNAL_DTD));
            }
        } else {
            try {
                factory.setFeature("http://apache.org/xml/features/validation/dynamic", true);
                factory.setFeature("http://apache.org/xml/features/validation/schema", false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        long l = System.currentTimeMillis();
        System.out.println(Driver.localize(MSG_START_PARSING_GRAMMAR));
        Grammar grammar = null;
        try {
            GrammarLoader grammarLoader = new GrammarLoader();
            grammarLoader.setController(new DebugController(bl3, false, (EntityResolver)catalogResolver));
            grammarLoader.setSAXParserFactory(factory);
            grammarLoader.setStrictCheck(bl5);
            grammar = grammarLoader.parse(string);
        }
        catch (SAXParseException sAXParseException) {
            if (Debug.debug) {
                sAXParseException.getException().printStackTrace();
            }
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() != null) {
                throw sAXException.getException();
            }
            throw sAXException;
        }
        if (grammar == null) {
            System.out.println(Driver.localize(ERR_LOAD_GRAMMAR));
            return -1;
        }
        long l2 = System.currentTimeMillis();
        if (bl2) {
            System.out.println(Driver.localize(MSG_PARSING_TIME, new Long(l2 - l)));
        }
        if (bl) {
            if (grammar instanceof RELAXModule) {
                Driver.dumpRELAXModule((RELAXModule)grammar);
            } else if (grammar instanceof RELAXGrammar) {
                Driver.dumpRELAXGrammar((RELAXGrammar)grammar);
            } else if (grammar instanceof TREXGrammar) {
                Driver.dumpTREX((TREXGrammar)grammar);
            } else if (grammar instanceof XMLSchemaGrammar) {
                Driver.dumpXMLSchema((XMLSchemaGrammar)grammar);
            }
            return -1;
        }
        DocumentVerifier documentVerifier = grammar instanceof RELAXGrammar ? new RELAXNSVerifier((SchemaProvider)new SchemaProviderImpl((RELAXGrammar)grammar)) : (grammar instanceof XMLSchemaGrammar ? new XMLSchemaVerifier((XMLSchemaGrammar)grammar) : new SimpleVerifier(new REDocumentDeclaration(grammar)));
        boolean bl7 = true;
        int n3 = 0;
        while (n3 < vector.size()) {
            String string3 = (String)vector.elementAt(n3);
            System.out.println(Driver.localize(MSG_VALIDATING, string3));
            boolean bl8 = false;
            try {
                XMLReader xMLReader = factory.newSAXParser().getXMLReader();
                if (catalogResolver != null) {
                    xMLReader.setEntityResolver((EntityResolver)catalogResolver);
                }
                xMLReader.setErrorHandler(new ReportErrorHandler());
                bl8 = documentVerifier.verify(xMLReader, Util.getInputSource(string3), bl6);
            }
            catch (ValidationUnrecoverableException validationUnrecoverableException) {
                System.out.println(Driver.localize(MSG_BAILOUT));
            }
            catch (SAXParseException sAXParseException) {
                sAXParseException.getException().printStackTrace();
            }
            catch (SAXException sAXException) {
                sAXException.getException().printStackTrace();
            }
            if (bl8) {
                System.out.println(Driver.localize(MSG_VALID));
            } else {
                System.out.println(Driver.localize(MSG_INVALID));
                bl7 = false;
            }
            if (n3 != vector.size() - 1) {
                System.out.println("--------------------------------------");
            }
            ++n3;
        }
        if (bl2) {
            System.out.println(Driver.localize(MSG_VALIDATION_TIME, new Long(System.currentTimeMillis() - l2)));
        }
        return bl7 ? 0 : -1;
    }

    public static void dumpTREX(TREXGrammar tREXGrammar) throws Exception {
        System.out.println("*** start ***");
        System.out.println(ExpressionPrinter.printFragment(tREXGrammar.exp));
        System.out.println("*** others ***");
        System.out.print(ExpressionPrinter.fragmentInstance.printRefContainer(tREXGrammar.namedPatterns));
    }

    public static void dumpXMLSchema(XMLSchemaGrammar xMLSchemaGrammar) throws Exception {
        System.out.println("*** top level ***");
        System.out.println(ExpressionPrinter.printFragment(xMLSchemaGrammar.topLevel));
        Iterator iterator = xMLSchemaGrammar.iterateSchemas();
        while (iterator.hasNext()) {
            XMLSchemaSchema xMLSchemaSchema = (XMLSchemaSchema)iterator.next();
            Driver.dumpXMLSchema(xMLSchemaSchema);
        }
    }

    public static void dumpXMLSchema(XMLSchemaSchema xMLSchemaSchema) throws Exception {
        System.out.println("\n $$$$$$[ " + xMLSchemaSchema.targetNamespace + " ]$$$$$$");
        System.out.println("*** elementDecls ***");
        ReferenceExp[] referenceExpArray = xMLSchemaSchema.elementDecls.getAll();
        int n = 0;
        while (n < referenceExpArray.length) {
            ElementDeclExp elementDeclExp = (ElementDeclExp)referenceExpArray[n];
            System.out.println(elementDeclExp.name + "  : " + ExpressionPrinter.printContentModel(elementDeclExp.getContentModel().getExpandedExp(xMLSchemaSchema.pool)));
            ++n;
        }
        System.out.println("*** complex types ***");
        System.out.print(ExpressionPrinter.contentModelInstance.printRefContainer(xMLSchemaSchema.complexTypes));
    }

    public static void dumpRELAXModule(RELAXModule rELAXModule) throws Exception {
        System.out.println("*** top level ***");
        System.out.println(ExpressionPrinter.printFragment(rELAXModule.topLevel));
        System.out.println("\n $$$$$$[ " + rELAXModule.targetNamespace + " ]$$$$$$");
        System.out.println("*** elementRule ***");
        System.out.print(ExpressionPrinter.fragmentInstance.printRefContainer(rELAXModule.elementRules));
        System.out.println("*** hedgeRule ***");
        System.out.print(ExpressionPrinter.fragmentInstance.printRefContainer(rELAXModule.hedgeRules));
        System.out.println("*** attPool ***");
        System.out.print(ExpressionPrinter.fragmentInstance.printRefContainer(rELAXModule.attPools));
        System.out.println("*** tag ***");
        System.out.print(ExpressionPrinter.fragmentInstance.printRefContainer(rELAXModule.tags));
    }

    public static void dumpRELAXGrammar(RELAXGrammar rELAXGrammar) throws Exception {
        System.out.println("operation is not implemented yet.");
    }

    public static String localize(String string, Object[] objectArray) {
        String string2 = ResourceBundle.getBundle("com.sun.msv.driver.textui.Messages").getString(string);
        return MessageFormat.format(string2, objectArray);
    }

    public static String localize(String string) {
        return Driver.localize(string, null);
    }

    public static String localize(String string, Object object) {
        return Driver.localize(string, new Object[]{object});
    }

    public static String localize(String string, Object object, Object object2) {
        return Driver.localize(string, new Object[]{object, object2});
    }

    private static class XMLSchemaVerifier
    implements DocumentVerifier {
        private final XMLSchemaGrammar grammar;

        XMLSchemaVerifier(XMLSchemaGrammar xMLSchemaGrammar) {
            this.grammar = xMLSchemaGrammar;
        }

        public boolean verify(XMLReader xMLReader, InputSource inputSource, boolean bl) throws Exception {
            ReportErrorHandler reportErrorHandler = new ReportErrorHandler();
            IDConstraintChecker iDConstraintChecker = new IDConstraintChecker(this.grammar, (ErrorHandler)reportErrorHandler);
            iDConstraintChecker.setPanicMode(bl);
            xMLReader.setDTDHandler(iDConstraintChecker);
            xMLReader.setContentHandler(iDConstraintChecker);
            xMLReader.setErrorHandler(reportErrorHandler);
            xMLReader.parse(inputSource);
            return iDConstraintChecker.isValid();
        }
    }

    private static class SimpleVerifier
    implements DocumentVerifier {
        private final DocumentDeclaration docDecl;

        SimpleVerifier(DocumentDeclaration documentDeclaration) {
            this.docDecl = documentDeclaration;
        }

        public boolean verify(XMLReader xMLReader, InputSource inputSource, boolean bl) throws Exception {
            ReportErrorHandler reportErrorHandler = new ReportErrorHandler();
            Verifier verifier = new Verifier(this.docDecl, reportErrorHandler);
            verifier.setPanicMode(bl);
            xMLReader.setDTDHandler(verifier);
            xMLReader.setContentHandler(verifier);
            xMLReader.setErrorHandler(reportErrorHandler);
            xMLReader.parse(inputSource);
            return verifier.isValid();
        }
    }

    private static class RELAXNSVerifier
    implements DocumentVerifier {
        private final SchemaProvider sp;

        RELAXNSVerifier(SchemaProvider schemaProvider) {
            this.sp = schemaProvider;
        }

        public boolean verify(XMLReader xMLReader, InputSource inputSource, boolean bl) throws Exception {
            DispatcherImpl dispatcherImpl = new DispatcherImpl(this.sp);
            dispatcherImpl.attachXMLReader(xMLReader);
            ReportErrorHandler reportErrorHandler = new ReportErrorHandler();
            dispatcherImpl.setErrorHandler((ErrorHandler)reportErrorHandler);
            xMLReader.parse(inputSource);
            return !reportErrorHandler.hadError;
        }
    }

    private static interface DocumentVerifier {
        public boolean verify(XMLReader var1, InputSource var2, boolean var3) throws Exception;
    }
}

