/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.util;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.core.util.LocaleComparator;
import com.atlassian.core.util.XMLUtils;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Category;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class LocaleUtils {
    private static final Category log = Category.getInstance(LocaleUtils.class);
    public static final String LANGUAGE_DESCRIPTOR_FILENAME = "language-descriptor.xml";
    public static final String LOCALE_TAG_NAME = "locale";
    public List installedLocales;

    public List getInstalledLocales() throws IOException {
        if (this.installedLocales == null) {
            this.installedLocales = new ArrayList();
            URL url = null;
            Enumeration localeDescriptors = ClassLoaderUtils.getResources(LANGUAGE_DESCRIPTOR_FILENAME, this.getClass());
            while (localeDescriptors.hasMoreElements()) {
                try {
                    url = (URL)localeDescriptors.nextElement();
                    DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Document xmlDoc = db.parse(url.openConnection().getInputStream());
                    Element root = xmlDoc.getDocumentElement();
                    String locale = XMLUtils.getContainedText(root, LOCALE_TAG_NAME);
                    if (TextUtils.stringSet((String)locale)) {
                        this.installedLocales.add(this.getLocale(locale));
                        continue;
                    }
                    throw new IllegalArgumentException("The locale element must be set in " + url);
                }
                catch (IOException e) {
                    log.error((Object)("Error while reading language descriptor '" + url + "'."), (Throwable)e);
                }
                catch (ParserConfigurationException e) {
                    log.error((Object)("Error while parsing language descriptor '" + url + "'."), (Throwable)e);
                }
                catch (SAXException e) {
                    log.error((Object)("Error while parsing language descriptor '" + url + "'."), (Throwable)e);
                }
            }
            Collections.sort(this.installedLocales, new LocaleComparator());
        }
        return this.installedLocales;
    }

    public Locale getLocale(String locale) {
        if (TextUtils.stringSet((String)locale)) {
            int _pos = locale.indexOf("_");
            if (_pos != -1) {
                return new Locale(locale.substring(0, _pos), locale.substring(_pos + 1));
            }
            return new Locale(locale, "");
        }
        return null;
    }
}

