/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.util;

public class ProgressMeter {
    int percentageComplete;
    private String status;
    private int total;
    private int currentCount;
    private boolean completedSuccessfully = true;

    public void setPercentage(int count, int total) {
        if (total < 0) {
            this.percentageComplete = 0;
        } else if (total <= count) {
            this.percentageComplete = 100;
        } else {
            this.percentageComplete = (int)(100.0f * (float)count / (float)total);
            if (count < total && this.percentageComplete == 100) {
                this.percentageComplete = 99;
            }
        }
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public int getPercentageComplete() {
        return this.percentageComplete;
    }

    public String getStatus() {
        return this.status;
    }

    public void setPercentage(int percentageComplete) {
        this.percentageComplete = percentageComplete;
    }

    public int getCurrentCount() {
        return this.currentCount;
    }

    public void setCurrentCount(int currentCount) {
        this.currentCount = currentCount;
        this.updatePercentageComplete();
    }

    private void updatePercentageComplete() {
        this.setPercentage(this.getCurrentCount(), this.getTotal());
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotalObjects(int total) {
        this.total = total;
        this.updatePercentageComplete();
    }

    public boolean isCompletedSuccessfully() {
        return this.completedSuccessfully;
    }

    public void setCompletedSuccessfully(boolean completedSuccessfully) {
        this.completedSuccessfully = completedSuccessfully;
    }
}

